//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;
using mshtml;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Ipc;
using MecInfoDll;

namespace nispi.Analysis
{
    class AnalysisMecab
    {
        public string datUrl;

        public AnalysisMecabControls analysisMecabControls;

        public static bool Visible;

        public static MecInfo mecInfo = new MecInfo();

        public AnalysisMecab()
        {
            analysisMecabControls = new AnalysisMecabControls(this);

            Visible = true;
        }

        private void OpenThread(object o)
        {
            DatInfo dat = (DatInfo)o;
            datUrl = dat.dat_url;
            List<MecWordList> mecwords = null;

            try
            {
                //MecInfo mecInfo = new MecInfo();
                mecwords = mecInfo.GetMecWord(dat.comments);
                if (mecwords == null)
                    return;
                Const.form.mainForm.Invoke(new write_analysis_html_Delegate(write_analysis_html), mecwords);
                mecwords.Clear();
            }
            catch { ;}
        }
        public void Open(DatInfo dat)
        {
            try
            {
                this.analysisMecabControls.browserParts.BrowserClear();

                //datCX^Xgĉ̓XbhJnB
                Thread t = new Thread(new ParameterizedThreadStart(OpenThread));
                t.IsBackground = true;
                t.Start((object)dat);
            }
            catch { ;}
        }
        delegate void write_analysis_html_Delegate(List<MecWordList> mecwords);

        public void write_analysis_html(List<MecWordList> mecwords)
        {
            System.Text.StringBuilder sb = new System.Text.StringBuilder();

            sb.Append("<html><head><style type=\"text/css\">");

            /*string cssHeader = string.Format(
                "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';}}",
                Const.opt.outWardBrowser.BrowserFontSize,
                "black",
                Const.opt.outWardBrowser.BrowserBackColor,
                Const.opt.outWardBrowser.BrowserFontName);*/
            string cssHeader = "";
            if (Const.opt.outWardBrowser.BrowserFontType.Equals("installed") == true)
            {
                cssHeader = string.Format(
                    "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';}}",
                    Const.opt.outWardBrowser.BrowserFontSize,
                    Const.opt.outWardBrowser.BrowserForeColor,
                    Const.opt.outWardBrowser.BrowserBackColor,
                    Const.opt.outWardBrowser.BrowserFontName);
            }
            else
            {
                cssHeader = string.Format(
                    "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';src: url(\"file:///{4}\");}}",
                    Const.opt.outWardBrowser.BrowserOriginalFontSize,
                    Const.opt.outWardBrowser.BrowserForeColor,
                    Const.opt.outWardBrowser.BrowserBackColor,
                    Const.opt.outWardBrowser.BrowserOriginalFontName,
                    Const.opt.outWardBrowser.BrowserOriginalFontPath);
            }

            sb.Append(cssHeader);

            sb.Append(Const.Default_Style_Sheet);
            sb.Append("</style>");
            sb.Append("</head>");
            string htmlHeader = string.Format("<body link='#{0}' vlink='#{1}'>",
                Const.opt.outWardBrowser.BrowserLinkColor,
                Const.opt.outWardBrowser.BrowserLinkedColor);

            sb.Append(htmlHeader);

            foreach (MecWordList mcList in mecwords)
            {
                sb.Append(string.Format("<BR><table border=\"0\" width=\"400\" bgcolor=\"#{0}aa\"><TD><B>{1}</B></TD></table><BR>", Const.opt.outWardBrowser.BrowserBackColor.Substring(2,4),mcList.name));
                foreach (MecWord mc in mcList.mecWord)
                {
                    
                    sb.Append(string.Format("<B><a href='javascript:void(0);#WORD#{0}'>{0}</a></B> ", mc.mecword));
                    foreach (string word in mc.list)
                    {
                        sb.Append(string.Format("<a href='javascript:void(0);#ANARYNUM#{0}#{1}'>&gt;&gt;{0}</a> ", word, datUrl));
                    }
                }
            }
            sb.Append("</html>");

            this.analysisMecabControls.browserParts.BrowserClear();

            this.analysisMecabControls.browserParts.Write(sb.ToString());
            this.analysisMecabControls.browserParts.AllowNavigation = false;

            this.analysisMecabControls.amFormParts.Text = "Pꒊo";
        }

        public void Cloose()
        {
            try
            {
                this.analysisMecabControls.RemoveControls();
            }
            catch { ;}

            Visible = false;
        }
    }
}
