//CZXAgeOntH_LISENCEtH_QƂĂ

using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Drawing;
using System.IO;

using nispi.controlclass;

namespace nispi
{
    class BoardIndexView : BoardIndexViewCommon
    {
        //public static string address = "";
        //public static bool firstTask = true;

        public string boardIndexAddress;
        public string boardType;

        private static int firstStep = 0;

        delegate void ShowToolTipDelegate(string text, TreeViewParts treeViewParts);
        delegate void WriteBoardList_Delegate(TreeViewParts treeViewParts, string str, string boardType);

        public BoardIndexView(string boardIndexAddress)
        {
            this.boardIndexAddress = boardIndexAddress;
            this.boardType = Util.BoardUrlToBoardTypeName(this.boardIndexAddress);
            boardIndexControls = new BoardIndexControls(this as BoardIndexViewCommon);

            Const.form.boardIndexTabControlParts.AddControl(boardIndexControls.tabPageExParts);
        }

        private void reload_button_Click(object sender, EventArgs e)
        {
            Thread t2 = new Thread(new ThreadStart(LoadBoardListThread));
            t2.IsBackground = true;
            t2.Start();
        }
        public void LoadBoardListFromStr(string str)
        {
            //BoardDataBase.MyClear();
            Const.form.mainForm.Invoke(new WriteBoardList_Delegate(this.boardIndexControls.treeViewParts.WriteBoardList), boardIndexControls.treeViewParts, str, this.boardType);
        }

        public void LoadBoardList()
        {
            Thread t2 = new Thread(new ThreadStart(LoadBoardListThread));
            t2.IsBackground = true;
            t2.Start();
        }
        

        public void LoadBoardListThread()
        {
            Const.form.mainForm.Invoke(new ShowToolTipDelegate(this.boardIndexControls.toolTipParts.ShowToolTip),
                "j[ǂݍݒ...", this.boardIndexControls.treeViewParts);
            string str = "";
                            //IC̎̓
            if (Const.OnLine == true)
            {
                try
                {
                    DownloadIndex di = new DownloadIndex();
                    if (true == di.DownloadIndexText(this.boardIndexAddress))
                        str = di.httpResData;
                    else
                        return;

                    //BoardDataBase.MyClear();
                    Const.form.mainForm.Invoke(new WriteBoardList_Delegate(this.boardIndexControls.treeViewParts.WriteBoardList), boardIndexControls.treeViewParts, str, this.boardType);
                }
                catch (System.Exception ex)
                {
                    Const.debugForm.OutPutDebug("BoardIndex", ex);
                }
            }
            //ItĈƂ̓
            else
            {
                str = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + this.boardType, "bbsindex.html");
                Const.form.mainForm.Invoke(new WriteBoardList_Delegate(this.boardIndexControls.treeViewParts.WriteBoardList), boardIndexControls.treeViewParts, str, this.boardType);
            }

            Const.form.mainForm.Invoke(new Action(this.boardIndexControls.toolTipParts.HideToolTip));

            if (firstStep == 0)
            {
                
                //sc̃CfbNXǂݍ񂾎_őȌȈԂɕA
                if (this.boardIndexAddress.Contains("machi.to") == true)
                {
                    firstStep = 1;
                    Thread.Sleep(2000);
                    if (Const.opt.otherOption.IsSaveOpenWindow.Equals("True") == true)
                    {
                        try
                        {
                            SaveBoardAndThread.SaveBoard board = new SaveBoardAndThread.SaveBoard();
                            board.Read();

                            SaveBoardAndThread.SaveThread thread = new SaveBoardAndThread.SaveThread();
                            thread.Read();
                        }
                        catch { ;}
                    }
                }
            }
        }




    }
}