﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.WriteToBoard;

namespace nispi.controlclass
{
    class BoardListControlEvent
    {
        BoardViewCommon boardView;
        BoardListControls boardListControls;

        public BoardListControlEvent(BoardListControls boardListControls, BoardViewCommon boardView)
        {
            this.boardListControls = boardListControls;
            this.boardView = boardView;

            this.boardListControls.searchTextBoxParts.KeyPress += new KeyPressEventHandler(search_textBox_KeyPress);

            this.boardListControls.searchButtonParts.Click += new EventHandler(search_button_Click);

            this.boardListControls.extractionButtonParts.Click += new EventHandler(extraction_button_Click);

            this.boardListControls.reloadButtonParts.Click += new EventHandler(reload_button_Click);

            this.boardListControls.favoriteButtonParts.Click += new EventHandler(favoriteButtonParts_Click);

            this.boardListControls.kakoLogCBoxParts.SelectedIndexChanged += new EventHandler(kakoLogCBox_MouseClick);

            this.boardListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_MouseClick);

            this.boardListControls.pinPointDateButtonParts.Click += new EventHandler(pinPointDateButton_Click);

            this.boardListControls.timeOffButtonParts.Click += new EventHandler(timeOffButton_Click);

            this.boardListControls.closeTabButtonParts.Click += new EventHandler(closeTabButton_Click);

            this.boardListControls.writeButtonParts.Click += new EventHandler(writeButtonParts_Click);
        }
        public void RemoveEvent()
        {
            this.boardListControls.searchTextBoxParts.KeyPress -= new KeyPressEventHandler(search_textBox_KeyPress);

            this.boardListControls.searchButtonParts.Click -= new EventHandler(search_button_Click);

            this.boardListControls.extractionButtonParts.Click -= new EventHandler(extraction_button_Click);

            this.boardListControls.reloadButtonParts.Click -= new EventHandler(reload_button_Click);

            this.boardListControls.favoriteButtonParts.Click -= new EventHandler(favoriteButtonParts_Click);

            this.boardListControls.kakoLogCBoxParts.SelectedIndexChanged -= new EventHandler(kakoLogCBox_MouseClick);

            this.boardListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_MouseClick);

            this.boardListControls.pinPointDateButtonParts.Click -= new EventHandler(pinPointDateButton_Click);

            this.boardListControls.timeOffButtonParts.Click -= new EventHandler(timeOffButton_Click);

            this.boardListControls.closeTabButtonParts.Click -= new EventHandler(closeTabButton_Click);

            this.boardListControls.writeButtonParts.Click -= new EventHandler(writeButtonParts_Click);
        }

        //お気に入りに追加する
        delegate void WriteFavoriteBoardList_Delegate(TreeViewParts treeViewParts);
        
        public void favoriteButtonParts_Click(object sender, EventArgs e)
        {
            string url = boardView.board_url;
            string boardName = BoardDataBase.GetName(url);
            if (boardName.Length == 0)
                return;

            string type = Util.BoardUrlToBoardTypeName(url);

            //お気に入りに加える
            FavoriteBoardManager.Add(boardName, url, type);
            FavoriteBoardManager.Save();

            //お気に入りを再読み込みする
            FavoriteBoardManager.LoadFavorite();
            //GUIに再出力する4
            //if (FavoriteBoardManager.favoriteBoardList.Count == 0)
            //    return; ;
            Const.form.mainForm.Invoke(
                new WriteFavoriteBoardList_Delegate(
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.WriteFavoriteBoardList),
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts);
            /*try
            {
                //複数選択に対応
                foreach (int num in this.boardListControls.listViewParts.GetSelectedIndices())
                {
                    string datUrl = this.boardListControls.listViewParts.items[num].Name;
                    string title = this.boardListControls.listViewParts.items[num].SubItems_3_Text;
                    string resNum = this.boardListControls.listViewParts.items[num].SubItems_4_Text;

                    //登録
                    MainFormConst.boardListTabMain.favoriteBoardView.Register(datUrl, title, resNum);

                }
                //再描画
                MainFormConst.boardListTabMain.favoriteBoardView.show_board("local://favorite/thread");
                return;

            }
            catch { ;}*/
        }

        public void withInCBox_MouseClick(object sender, EventArgs e)
        {
            try
            {
                //this.boardListControls.pinPointDateButtonParts.Text = "日時指定";

                //boardView.bvExtraction.boardView.bvExtraction.pinPointJPDate = "";

                Const.form.mainForm.SetWaitCursor();

                boardView.bvTimeExtraction.SetData(
                    boardView.board_url,
                    this.boardListControls.kakoLogCBoxParts.SelectedIndex,
                    this.boardListControls.withInCBoxParts.SelectedIndex, "");

                Const.form.mainForm.ReSetWaitCursor();
            }
            catch { ;}
        }

        public void kakoLogCBox_MouseClick(object sender, EventArgs e)
        {
            try
            {
                Const.form.mainForm.SetWaitCursor();

                this.boardView.bvTimeExtraction.SetData(
                    this.boardView.board_url,
                    this.boardListControls.kakoLogCBoxParts.SelectedIndex,
                    this.boardListControls.withInCBoxParts.SelectedIndex,
                    this.boardView.bvTimeExtraction.pinPointData);

                Const.form.mainForm.ReSetWaitCursor();
            }
            catch { ;}
        }

        public void pinPointDateButton_Click(object sender, EventArgs e)
        {
            try
            {
                /*kakoLogCBox.SelectedIndexChanged -= new EventHandler(kakoLogCBox_MouseClick);
                kakoLogCBox.SelectedIndex = 1;
                kakoLogCBox.SelectedIndexChanged += new EventHandler(kakoLogCBox_MouseClick);*/

                this.boardListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_MouseClick);
                this.boardListControls.withInCBoxParts.SelectedIndex = 0;
                this.boardListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_MouseClick);

                CalendarInBoardView calendarInBoardView = new CalendarInBoardView(
                    this.boardListControls.kakoLogCBoxParts.SelectedIndex,
                    Cursor.Position,
                    this.boardView.board_url, this.boardView.bvTimeExtraction);
            }
            catch { ;}
        }

        public void timeOffButton_Click(object sender, EventArgs e)
        {
            this.boardListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_MouseClick);
            this.boardListControls.withInCBoxParts.SelectedIndex = 0;
            this.boardListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_MouseClick);

            this.boardListControls.kakoLogCBoxParts.SelectedIndexChanged -= new EventHandler(kakoLogCBox_MouseClick);
            this.boardListControls.kakoLogCBoxParts.SelectedIndex = 0;
            this.boardListControls.kakoLogCBoxParts.SelectedIndexChanged += new EventHandler(kakoLogCBox_MouseClick);

            //this.boardView.bvExtraction.boardView.bvExtraction.pinPointJPDate = "";
            //this.boardListControls.pinPointDateButtonParts.Text = "日時指定";

            Const.form.mainForm.SetWaitCursor();

            //時間による抽出したデータをnullにする
            boardView.bvTimeExtraction.SetData(boardView.board_url, 0, 0, "");
            //単語により抽出したデータをnullにする
            boardView.wordExtraction.Clear();

            //再描画
            Const.form.mainForm.Invoke(new Action(this.boardView.Write_List_Dele));

            Const.form.mainForm.ReSetWaitCursor();
        }

        //検索ボタン
        public void search_button_Click(object sender, EventArgs e)
        {
            string searchText = this.boardListControls.searchTextBoxParts.Text;
            if ((searchText != null) && (searchText.Length > 0))
                this.boardListControls.listViewParts.SearchListView(searchText);
        }

        public void search_textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                string searchText = this.boardListControls.searchTextBoxParts.Text;
                if ((searchText != null) && (searchText.Length > 0)) 
                    this.boardListControls.listViewParts.SearchListView(searchText);
            }
        }

        public void extraction_button_Click(object sender, EventArgs e)
        {
            string searchText = this.boardListControls.searchTextBoxParts.Text;
            if ((searchText != null) && (searchText.Length > 0))
                this.boardView.wordExtraction.GetWordExtraction(searchText);

            //再描画
            Const.form.mainForm.Invoke(new Action(this.boardView.Write_List_Dele));
        }

        public void reload_button_Click(object sender, EventArgs e)
        {
            int index = Const.form.boardListTabControlParts.SelectedIndex;

            if (index == 0)
            {
                Crawler crawler = new Crawler();
                crawler.Open();
                return;
            }

            Thread t = new Thread(new ThreadStart(boardView.worker));
            t.IsBackground = true;
            t.Start();
        }

        public void closeTabButton_Click(object sender, EventArgs e)
        {
            this.boardView.Dispoose();
        }


        public void writeButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                WriteMain writeMainForm = new WriteMain(boardView);
            }
            catch { ;}
        }
    }
}
