﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using mshtml;
using System.Windows.Forms;

using nispi;
using nispi.controlclass;

//タブの右下の▼をクリックしたときのメニュー
//開かれているスレッドをメニュー形式で表示
namespace nispi.Menu
{
    class AllBoardIndexMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts _2chMenuItem;
        public ToolStripMenuItemParts _2chSCMenuItem;
        public ToolStripMenuItemParts open2chMenuItem;
        public ToolStripMenuItemParts next2chMenuItem;
        public ToolStripMenuItemParts jikkyoMenuItem;
        public ToolStripMenuItemParts blogbanMenuItem;
        public ToolStripMenuItemParts shizuMenuItem;
        public ToolStripMenuItemParts vip2chMenuItem;
        public ToolStripMenuItemParts machiMenuItem;
        public ToolStripMenuItemParts favoriteMenuItem;

        public AddressMenuEvent addressEvent;

        public AllBoardIndexMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();

            _2chMenuItem = ToolStripMenuItemPartsManager.Pop();
            _2chMenuItem.Text = MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Text;
            _2chMenuItem.Name = MainFormConst.boardIndexTabMain.boardIndexView.indexUrl;
            _2chMenuItem.Image = Resources.favicon_2ch;
            _2chMenuItem.Click += new EventHandler(menuItemBoard_Click);

            _2chSCMenuItem = ToolStripMenuItemPartsManager.Pop();
            _2chSCMenuItem.Text = MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Text;
            _2chSCMenuItem.Name = MainFormConst.boardIndexTabMain.scBoardIndexView.indexUrl;
            _2chSCMenuItem.Image = Resources.favicon_sc;
            _2chSCMenuItem.Click += new EventHandler(menuItemBoard_Click);

            open2chMenuItem = ToolStripMenuItemPartsManager.Pop();
            open2chMenuItem.Text = MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            open2chMenuItem.Name = MainFormConst.boardIndexTabMain.open2chBoardIndexView.indexUrl;
            open2chMenuItem.Image = Resources.favicon_open2ch;
            open2chMenuItem.Click += new EventHandler(menuItemBoard_Click);


            next2chMenuItem = ToolStripMenuItemPartsManager.Pop();
            next2chMenuItem.Text = MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            next2chMenuItem.Name = MainFormConst.boardIndexTabMain.next2chBoardIndexView.indexUrl;
            next2chMenuItem.Image = Resources.favicon_next2ch;
            next2chMenuItem.Click += new EventHandler(menuItemBoard_Click);


            jikkyoMenuItem = ToolStripMenuItemPartsManager.Pop();
            jikkyoMenuItem.Text = MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Text;
            jikkyoMenuItem.Name = MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.indexUrl;
            jikkyoMenuItem.Image = Resources.favicon_jikkyo;
            jikkyoMenuItem.Click += new EventHandler(menuItemBoard_Click);

            blogbanMenuItem = ToolStripMenuItemPartsManager.Pop();
            blogbanMenuItem.Text = MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Text;
            blogbanMenuItem.Name = MainFormConst.boardIndexTabMain.blogbanBoardIndexView.indexUrl;
            blogbanMenuItem.Image = Resources.favicon_blogban;
            blogbanMenuItem.Click += new EventHandler(menuItemBoard_Click);


            shizuMenuItem = ToolStripMenuItemPartsManager.Pop();
            shizuMenuItem.Text = MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Text;
            shizuMenuItem.Name = MainFormConst.boardIndexTabMain.shizuBoardIndexView.indexUrl;
            shizuMenuItem.Image = Resources.favicon_shizu;
            shizuMenuItem.Click += new EventHandler(menuItemBoard_Click);

            vip2chMenuItem = ToolStripMenuItemPartsManager.Pop();
            vip2chMenuItem.Text = MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            vip2chMenuItem.Name = MainFormConst.boardIndexTabMain.vip2chBoardIndexView.indexUrl;
            vip2chMenuItem.Image = Resources.favicon_vip2ch;
            vip2chMenuItem.Click += new EventHandler(menuItemBoard_Click);

            machiMenuItem = ToolStripMenuItemPartsManager.Pop();
            machiMenuItem.Text = MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Text;
            machiMenuItem.Name = MainFormConst.boardIndexTabMain.machibbsBoardIndexView.indexUrl;
            machiMenuItem.Image = Resources.favicon_machi;
            machiMenuItem.Click += new EventHandler(menuItemBoard_Click);

            favoriteMenuItem = ToolStripMenuItemPartsManager.Pop();
            favoriteMenuItem.Text = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Text;
            favoriteMenuItem.Name = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.indexUrl;
            favoriteMenuItem.Image = Resources.favorite;
            favoriteMenuItem.Click += new EventHandler(menuItemBoard_Click);

            contextMenuStripParts.ItemsAdd(_2chMenuItem);
            contextMenuStripParts.ItemsAdd(_2chSCMenuItem);
            contextMenuStripParts.ItemsAdd(open2chMenuItem);
            contextMenuStripParts.ItemsAdd(next2chMenuItem);
            contextMenuStripParts.ItemsAdd(jikkyoMenuItem);
            contextMenuStripParts.ItemsAdd(blogbanMenuItem);
            contextMenuStripParts.ItemsAdd(shizuMenuItem);
            contextMenuStripParts.ItemsAdd(vip2chMenuItem);
            contextMenuStripParts.ItemsAdd(machiMenuItem);
            contextMenuStripParts.ItemsAdd(favoriteMenuItem);

        }

        public void Show(Point point)
        {
            //表示位置を調節
            point.X -= contextMenuStripParts.Size.Width;
            point.Y -= contextMenuStripParts.Size.Height;
            contextMenuStripParts.Show(Const.form.boardIndexTabControlParts, point);
        }

        public bool CheckConsistency()
        {
            return true;
        }

        public void menuItemBoard_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = ((ToolStripMenuItem)sender).Name;

            if (url.Equals(Const.BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 0;
            else if (url.Equals(Const.SC_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 1;
            else if (url.Equals(Const.OPEN2CH_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 2;
            else if (url.Equals(Const.NEXT2CH_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 3;
            else if (url.Equals(Const.JIKKYO_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 4;
            else if (url.Equals(Const.BLOGBAN_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 5;
            else if (url.Equals(Const.SHIZU_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 6;
            else if (url.Equals(Const.VIP2CH_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 7;
            else if (url.Equals(Const.MACHIBBS_BOARD_INDEX_ADDRESS) == true)
                Const.form.boardIndexTabControlParts.SelectedIndex = 8;
            else
                Const.form.boardIndexTabControlParts.SelectedIndex = 9;
        }
    }
}