﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

using nispi.controlclass;
namespace nispi
{
    class BoardIndexTreeViewMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts menuItemOpenParts;
        public ToolStripMenuItemParts menuItemAddFavoriteParts;
        public ToolStripMenuItemParts menuItemCopyURLParts;
        public ToolStripMenuItemParts menuItemCopyTitleParts;
        public ToolStripMenuItemParts menuItemOpenBrowserParts;
        public ToolStripMenuItemParts menuItemDeleteParts;
        public ToolStripMenuItemParts menuItemReloadParts;


        public BoardIndexTreeViewMenuEvent boardIndexTreeViewMenuEvent;

        public BoardIndexTreeViewMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();

            menuItemOpenParts = ToolStripMenuItemPartsManager.Pop();
            menuItemAddFavoriteParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyURLParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyTitleParts = ToolStripMenuItemPartsManager.Pop();
            menuItemOpenBrowserParts = ToolStripMenuItemPartsManager.Pop();
            menuItemDeleteParts = ToolStripMenuItemPartsManager.Pop();
            menuItemReloadParts = ToolStripMenuItemPartsManager.Pop();


            menuItemOpenParts.Text = "開く";

            menuItemAddFavoriteParts.Text = "お気に入りに追加する(&F)";

            menuItemCopyURLParts.Text = "URLをコピー";

            menuItemCopyTitleParts.Text = "板の名前をコピー";

            menuItemOpenBrowserParts.Text = "ブラウザで開く";
            menuItemDeleteParts.Text = "削除する(&D)";
            menuItemReloadParts.Text = "再読み込み(&R)";

          
            contextMenuStripParts.ItemsAdd(menuItemOpenParts);
            contextMenuStripParts.ItemsAdd(menuItemAddFavoriteParts);
            contextMenuStripParts.ItemsAdd(menuItemOpenBrowserParts);
            contextMenuStripParts.ItemsAdd("-");
            contextMenuStripParts.ItemsAdd(menuItemCopyURLParts);
            contextMenuStripParts.ItemsAdd(menuItemCopyTitleParts);
            contextMenuStripParts.ItemsAdd(menuItemDeleteParts);
            contextMenuStripParts.ItemsAdd(menuItemReloadParts);

            this.boardIndexTreeViewMenuEvent = new BoardIndexTreeViewMenuEvent(this);
        }
    }
}