﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.controlclass;
namespace nispi.Controls.UsefulAddress
{
    class UsefulBoardMenu
    {
        public ContextMenuStripParts contextMenuStripParts;

        public ToolStripMenuItemParts menuItemTabParts;

        public ThreadListTabEvent threadListTabEvent;

        public UsefulBoardMenu()
        {
            contextMenuStripParts = ContextMenuStripPartsManager.Pop();
            contextMenuStripParts.control.ItemClicked += new ToolStripItemClickedEventHandler(contextMenuStripParts_ToolStripItemClickedEventHandler);

            foreach (BoardData bd in UsefulBoard.boardDataList)
            {
                menuItemTabParts = ToolStripMenuItemPartsManager.Pop();
                
                menuItemTabParts.Text = bd.title;
                menuItemTabParts.Image = SetIcon(bd.address);
                menuItemTabParts.Name = bd.address;
                contextMenuStripParts.ItemsAdd(menuItemTabParts);
            }

            contextMenuStripParts.Show(Const.form.mainForm, Const.form.mainForm.control.PointToClient(Form.MousePosition));
        }

        private void contextMenuStripParts_ToolStripItemClickedEventHandler(object sender, ToolStripItemClickedEventArgs e)
        {
            MainFormConst.ShowBoard(e.ClickedItem.Name);

            contextMenuStripParts.control.ItemClicked -= new ToolStripItemClickedEventHandler(contextMenuStripParts_ToolStripItemClickedEventHandler);
            contextMenuStripParts.control.Items.Clear();
            ContextMenuStripPartsManager.Push(contextMenuStripParts);
        }

        private Bitmap SetIcon(string boardUrl)
        {
            string type = Util.BoardUrlToBoardTypeName(boardUrl);
            if (true == type.Equals("2chsc"))
                return Resources.favicon_sc;
            else if (true == type.Equals("2ch"))
                return Resources.favicon_2ch;
            else if (true == type.Equals("favorite"))
                return Resources.favorite;
            else if (true == type.Equals("screening"))
                return Resources.map;
            else if (true == type.Equals("open2ch"))
                return Resources.favicon_open2ch;
            else if (true == type.Equals("next2ch"))
                return Resources.favicon_next2ch;

            else if (true == type.Equals("jikkyo"))
                return Resources.favicon_jikkyo;
            else if (true == type.Equals("blogban"))
                return Resources.favicon_blogban;
            else if (true == type.Equals("shizu"))
                return Resources.favicon_shizu;

            else if (true == type.Equals("vip2ch"))
                return Resources.favicon_vip2ch;

            else if (true == type.Equals("machibbs"))
                return Resources.favicon_machi;
            else if (true == type.Equals("jbbs"))
                return Resources.favicon_jbbs;
            else
                return null;
        }

    }
}