﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
//using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;

namespace nispi
{
    public  class Ronin
    {
        public Ronin()
        {
        }

        public void LogOut()
        {
            Const.RoninSessionID = "";
            Const.RoninState = false;
        }

        public bool LogIn()
        {
            string idStr = Const.opt.logInOption.MaruID;
            string pwStr = Const.opt.logInOption.MaruPassWord;
            string url = "https://2chv.tora3.net/futen.cgi";
            string error = "";

            if (idStr.Length == 0)
                error = "IDが設定されていません";
            else if (pwStr.Length == 0)
                error = "パスワードが設定されていません";

            if (error.Length > 0)
            {
                MessageBox.Show(error,
                    "浪人ログイン・エラー",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                Const.RoninState = false;
                return false;
            }


            string postData = string.Format("ID={0}&PW={1}", idStr, pwStr);

            try
            {
                GetRoninSessionID getSessionID = new GetRoninSessionID();
                if (true == getSessionID.Send(url, postData))
                {
                    Const.RoninSessionID = getSessionID.httpResData.Substring(11, getSessionID.httpResData.Length - 11 - 2);
                    Const.RoninState = true;
                    return true;
                }
                else
                {
                    if (error.Length > 0)
                    {
                        MessageBox.Show("ログイン出来ませんでした",
                            "浪人ログイン・エラー",
                            MessageBoxButtons.OK,
                            MessageBoxIcon.Error);
                        Const.RoninState = false;
                        return false;
                    }
                }
                return false;
            }
            catch
            {
                return false;
            }
        }
    }
}
