﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace nispi.controlclass
{
    partial class SampleListViewParts : ControlBase
    {
        void listView_RetrieveVirtualItem(object sender, RetrieveVirtualItemEventArgs e)
        {
            e.Item = this.items[e.ItemIndex].control;
        }

        void control_DrawColumnHeader(object sender, DrawListViewColumnHeaderEventArgs e)
        {
            e.Graphics.FillRectangle(columnBackBrush, e.Bounds);
            e.Graphics.DrawString(e.Header.Text,
                new Font("Meiryo UI", 10.75F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128))),
                columnForeBrush,
                new PointF(1,1));
        }

        void control_DrawSubItem(object sender, DrawListViewSubItemEventArgs e)
        {
            /*if ((e.ItemState & ListViewItemStates.Focused) == 0)
            {
                e.Graphics.FillRectangle(SystemBrushes.Highlight,
                e.Bounds);
                e.Graphics.DrawString(e.Item.Text, control.Font,
                SystemBrushes.HighlightText, e.Bounds);
            }
            else
            {*/
                e.DrawBackground();
                e.DrawText();
            //}
        }
        //マウスが動いた時に、フォーカスが無いのならば与える（スクロールバークリック時に対応）
        public void listViewPart_MouseMove(object sender, MouseEventArgs e)
        {
            SampleListViewEx listViewEx = (SampleListViewEx)sender;
            if (listViewEx.ContainsFocus == false)
            {
                GetFocus(listViewEx);
            }
        }

        public void listViewPart_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (control.SelectedIndices.Count == 0)
                return;
            try
            {
                if ((this.oldItemNumList != null) && (this.oldItemNumList.Length != 0))
                {
                    foreach (int num in this.oldItemNumList)
                    {
                        this.items[num].ForeColor = SystemColors.MenuText;

                        if ((num % 2) == 0)
                            this.items[num].BackColor = System.Drawing.Color.AliceBlue;
                        else
                            this.items[num].BackColor = System.Drawing.Color.White;
                    }
                }
                //int[] newItemNumList = new int[control.SelectedIndices.Count];
                oldItemNumList = new int[control.SelectedIndices.Count];
                control.SelectedIndices.CopyTo(oldItemNumList, 0);
                //control.SelectedIndices.CopyTo(newItemNumList, 0);

                if ((oldItemNumList != null) && (oldItemNumList.Length != 0))
                {
                    foreach (int num in oldItemNumList)
                    {
                        this.items[num].BackColor = SystemColors.MenuHighlight;
                        this.items[num].ForeColor = System.Drawing.Color.White;
                    }
                }
            }
            catch
            {
            }
            return;
        }
    }
}
