﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Xml.Linq;
using System.Text.RegularExpressions;

namespace nispi.OptionControl
{
    class AbonOptionData
    {
        public List<AbonData> abonDataList;
        public Mutex mutex = new Mutex(false, "AbonOptionData");

        public AbonOptionData()
        {
            abonDataList = new List<AbonData>();
            GetXMLData();
        }

        public string ResetXML()
        {
            mutex.WaitOne();

            /*XNamespace ns = "AbonOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + ("Data" + "入力してください"), ""),
                new XElement(ns + ("Type" + "body"), ""),
                new XElement(ns + ("Flag" + "False"), ""));*/

            FileIO.SaveShiftJis("setting", "abon.xml", "");// doc.ToString());

            mutex.ReleaseMutex();

            return "";//doc.ToString();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "abon.xml");

            if ((str == null) || (str.Length == 0))
            {
                str = ResetXML();
                if (str.Length == 0)
                {
                    mutex.ReleaseMutex();
                    return;
                }
            }
            
            XDocument doc = XDocument.Parse(str);
            
            XNamespace ns = "AbonOptionData";
            XElement doc2 = doc.Element(ns + ("Option"));

            try
            {
                for (int num = 0; ; num += 1)
                {
                    string[] item = new string[4];

                    item[0] = doc2.Element(ns + ("Text" + num.ToString())).Value;
                    try
                    {
                        item[1] = doc2.Element(ns + ("RegFlag" + num.ToString())).Value;
                    }
                    catch
                    {
                        item[1] = "False";
                    }
                    item[2] = doc2.Element(ns + ("Type" + num.ToString())).Value;
                    item[3] = doc2.Element(ns + ("Flag" + num.ToString())).Value;
                    this.Add(item[0], item[1], item[2], item[3]);
                }
            }
            catch 
            {
            }

            mutex.ReleaseMutex();
        }

        public void SaveToFile()
        {
            mutex.WaitOne();

            int num = 0;

            //string xmlText = "";
            XNamespace ns = "AbonOptionData";
            XElement doc = new XElement(ns + "Option");

            foreach (AbonData abonData in abonDataList)
            {
                doc.Add(new XElement(ns + ("Text" + num.ToString()), abonData.data));
                doc.Add(new XElement(ns + ("RegFlag" + num.ToString()), abonData.regFlag));
                doc.Add(new XElement(ns + ("Type" + num.ToString()), abonData.type));
                doc.Add(new XElement(ns + ("Flag" + num.ToString()), abonData.flag));
                num += 1;
            }

            FileIO.SaveShiftJis("setting", "abon.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public bool Add(string data, string regFlag, string type, string flag)
        {
            if (data.Length == 0)
                return false;
            
            mutex.WaitOne();
            abonDataList.Add(new AbonData(data, regFlag, type, flag));
            mutex.ReleaseMutex();

            return true;
        }

        public void SortByName()
        {
            mutex.WaitOne();
            mutex.ReleaseMutex();
        }
        public void SortByType()
        {
            mutex.WaitOne();
            mutex.ReleaseMutex();
        }
        public void SortByON()
        {
            mutex.WaitOne();
            mutex.ReleaseMutex();
        }
        public void Remove(int num)
        {
            mutex.WaitOne();
            abonDataList.RemoveAt(num);
            mutex.ReleaseMutex();
        }

        public void Clear()
        {
            mutex.WaitOne();
            abonDataList.Clear();
            mutex.ReleaseMutex();
        }

        public AbonData[] GetAbonDataArray()
        {
            AbonData[] abonDataArray;

            mutex.WaitOne();
            abonDataArray = this.abonDataList.ToArray();
            mutex.ReleaseMutex();

            return abonDataArray;
        }
    }

    class AbonData
    {
        public string data;
        public string type;
        public string flag;
        public string regFlag;
        public Regex reg;

        public AbonData(string data, string regFlag, string type, string flag)
        {
            this.data = data;
            this.regFlag = regFlag;
            this.type = type;
            this.flag = flag;

            try
            {
                this.reg = new Regex(data);
            }
            catch
            {
                this.reg = null;
            }
        }
    }
}
