﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nispi.controlclass;
using System.Drawing;

namespace nispi.OptionControl
{
    //履歴のデータサイズ等表示して、削除も行うd
    class HistoryOption//:HistoryOptionData
    {
        TabPageExParts tabPageParts;
        
        //すべてのログに関する操作
        GroupBoxParts allGBoxParts;
        public ButtonParts openAllFolderButtonParts;
        public ButtonParts delAllButtonParts;
        //スレッドのログに関する操作
        GroupBoxParts threadGBoxParts;
        public ButtonParts delThreadButtonParts;
        public ButtonParts delImageButtonParts;
        //板のログに関する操作
        GroupBoxParts boardGBoxParts;
        public ButtonParts delBoardButtonParts;
        //書き込みのログに関する操作
        GroupBoxParts writeToBoardGboxParts;
        public ButtonParts wirteToBoardFolderButtonParts;
        public ButtonParts delWriteToBoardButtonParts;

        //書き込みのログに関する操作
        GroupBoxParts writeToThreadGboxParts;
        public ButtonParts wirteToThreadFolderButtonParts;
        public ButtonParts delWriteToThreadButtonParts;

        public OptionMainForm optionTabMain;

        public HistoryOptionEvent historyOptionEvent;

        public HistoryOption(OptionMainForm optionTabMain):base()
        {
            this.optionTabMain = optionTabMain;
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            tabPageParts = new TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "履歴";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            //////
            allGBoxParts = new GroupBoxParts();
            openAllFolderButtonParts = new ButtonParts();
            delAllButtonParts = new ButtonParts();

            allGBoxParts.Location = new Point(10, 10);
            allGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 100);
            allGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            allGBoxParts.Text = "すべてのログ";

            openAllFolderButtonParts.Location = new Point(20, 30);
            openAllFolderButtonParts.Size = new Size(160, 24);
            openAllFolderButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            openAllFolderButtonParts.Text = "保存しているフォルダを開く";

            delAllButtonParts.Location = new Point(20, 60);
            delAllButtonParts.Size = new Size(140, 24);
            delAllButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delAllButtonParts.Text = "すべてのログを削除する";

            tabPageParts.AddControl(allGBoxParts);
            allGBoxParts.AddControl(openAllFolderButtonParts);
            allGBoxParts.AddControl(delAllButtonParts);

            /////////
            threadGBoxParts = new GroupBoxParts();
            delThreadButtonParts = new ButtonParts();
            delImageButtonParts = new ButtonParts();

            threadGBoxParts.Location = new Point(10, 120);
            threadGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            threadGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            threadGBoxParts.Text = "スレッドのログ";

            delThreadButtonParts.Location = new Point(20, 30);
            delThreadButtonParts.Size = new Size(140, 24);
            delThreadButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delThreadButtonParts.Text = "すべてのログを削除する";

            delImageButtonParts.Location = new Point(170, 30);
            delImageButtonParts.Size = new Size(150, 24);
            delImageButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delImageButtonParts.Text = "すべての画像を削除する";

            tabPageParts.AddControl(threadGBoxParts);
            threadGBoxParts.AddControl(delThreadButtonParts);
            threadGBoxParts.AddControl(delImageButtonParts);

            ///
            boardGBoxParts = new GroupBoxParts();
            delBoardButtonParts = new ButtonParts();

            boardGBoxParts.Location = new Point(10, 200);
            boardGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            boardGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            boardGBoxParts.Text = "板のログ";

            delBoardButtonParts.Location = new Point(20, 30);
            delBoardButtonParts.Size = new Size(140, 24);
            delBoardButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delBoardButtonParts.Text = "すべてのログを削除する";

            tabPageParts.AddControl(boardGBoxParts);
            boardGBoxParts.AddControl(delBoardButtonParts);

            ///板への書き込み履歴
            writeToBoardGboxParts = new GroupBoxParts();
            wirteToBoardFolderButtonParts = new ButtonParts();
            delWriteToBoardButtonParts = new ButtonParts();

            writeToBoardGboxParts.Location = new Point(10, 280);
            writeToBoardGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 90);
            writeToBoardGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            writeToBoardGboxParts.Text = "スレッド作成の履歴";

            wirteToBoardFolderButtonParts.Location = new Point(20, 30);
            wirteToBoardFolderButtonParts.Size = new Size(160, 24);
            wirteToBoardFolderButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            wirteToBoardFolderButtonParts.Text = "保存しているフォルダを開く";

            delWriteToBoardButtonParts.Location = new Point(20, 60);
            delWriteToBoardButtonParts.Size = new Size(120, 24);
            delWriteToBoardButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delWriteToBoardButtonParts.Text = "ログを削除する";

            tabPageParts.AddControl(writeToBoardGboxParts);
            writeToBoardGboxParts.AddControl(wirteToBoardFolderButtonParts);
            writeToBoardGboxParts.AddControl(delWriteToBoardButtonParts);

            //スレッドへの書き込み履歴
            writeToThreadGboxParts = new GroupBoxParts();
            wirteToThreadFolderButtonParts = new ButtonParts();
            delWriteToThreadButtonParts = new ButtonParts();

            writeToThreadGboxParts.Location = new Point(10, 380);
            writeToThreadGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 90);
            writeToThreadGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            writeToThreadGboxParts.Text = "レスポンスの履歴";

            wirteToThreadFolderButtonParts.Location = new Point(20, 30);
            wirteToThreadFolderButtonParts.Size = new Size(160, 24);
            wirteToThreadFolderButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            wirteToThreadFolderButtonParts.Text = "保存しているフォルダを開く";

            delWriteToThreadButtonParts.Location = new Point(20, 60);
            delWriteToThreadButtonParts.Size = new Size(120, 24);
            delWriteToThreadButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            delWriteToThreadButtonParts.Text = "ログを削除する";

            tabPageParts.AddControl(writeToThreadGboxParts);
            writeToThreadGboxParts.AddControl(wirteToThreadFolderButtonParts);
            writeToThreadGboxParts.AddControl(delWriteToThreadButtonParts);


            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            historyOptionEvent = new HistoryOptionEvent(this);
        }

        public void SetDataToGUI()
        {
            
            historyOptionEvent.ResetEvent();

            historyOptionEvent.SetEvent();

        }
    }
}
