﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;


namespace nispi.OptionControl
{
    class OtherOption:OthreOptionData
    {
        TabPageExParts tabPageParts;

        GroupBoxParts userAgentGBoxParts;
        LabelParts userAgentLabelParts;
        public TextBoxParts userAgentTBoxParts;
        public ButtonParts userAgentResetButtonParts;

        GroupBoxParts proxyGBoxParts;
        public CheckBoxParts proxyCBoxParts;
        LabelParts proxyLabelParts;
        public TextBoxParts proxyTBoxParts;
        LabelParts portLabelParts;
        public TextBoxParts portTBoxParts;
        public ButtonParts proxyResetButtonParts;

        GroupBoxParts imageGBoxParts;
        public CheckBoxParts jpgParts;
        public CheckBoxParts pngParts;
        public CheckBoxParts gifParts;
        public CheckBoxParts bmpParts;
        //GroupBoxParts logGboxParts;
        //LabelParts logOpenLabelParts;
        //public TextBoxParts logOpenTBoxParts;
        //public ButtonParts logOpenButtonParts;
        //public ButtonParts logDefaultButtonParts;

        GroupBoxParts appGBoxParts;
        public CheckBoxParts taskCBoxParts;
        public CheckBoxParts saveCBoxParts;

        GroupBoxParts modeType2chGboxParts;
        public RadioButtonParts modeIERButtonParts;
        public RadioButtonParts mode2chRButtonParts;
        //public CheckBoxParts saveWriteCBoxParts;

        public OtherOptionEvent otherOptionEvent;

        public OptionMainForm optionTabMain;

        public OtherOption(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;

            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            tabPageParts = new TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "その他";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            //画像解析
            userAgentGBoxParts = new GroupBoxParts();
            userAgentLabelParts = new LabelParts();
            userAgentTBoxParts = new TextBoxParts();
            userAgentResetButtonParts = new ButtonParts();
            userAgentGBoxParts.Location = new Point(10, 10);
            userAgentGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            userAgentGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            userAgentGBoxParts.Text = "User-Agent";

            userAgentLabelParts.Location = new Point(20, 30);
            userAgentLabelParts.Size = new Size(100, 20);
            userAgentLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            userAgentLabelParts.Text = "User-Agent：";

            userAgentTBoxParts.Location = new Point(130, 30);
            userAgentTBoxParts.Size = new Size(300, 16);
            userAgentTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            userAgentResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            userAgentResetButtonParts.Size = new Size(100, 25);
            userAgentResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            userAgentResetButtonParts.Text = "元に戻す";

            tabPageParts.AddControl(userAgentGBoxParts);

            userAgentGBoxParts.AddControl(userAgentLabelParts);
            userAgentGBoxParts.AddControl(userAgentTBoxParts);
            userAgentGBoxParts.AddControl(userAgentResetButtonParts);

            //proxy
            proxyGBoxParts = new GroupBoxParts();
            proxyCBoxParts = new CheckBoxParts();
            proxyLabelParts = new LabelParts();
            proxyTBoxParts = new TextBoxParts();
            portLabelParts = new LabelParts();
            portTBoxParts = new TextBoxParts();
            proxyResetButtonParts = new ButtonParts();

            proxyGBoxParts.Location = new Point(10, 90);
            proxyGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 100);
            proxyGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            proxyGBoxParts.Text = "プロクシサーバ";

            proxyCBoxParts.Location = new Point(20, 30);
            proxyCBoxParts.Size = new Size(160, 25);
            proxyCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            proxyCBoxParts.Text = "プロクシを使用する";

            proxyLabelParts.Location = new Point(20, 60);
            proxyLabelParts.Size = new Size(60, 20);
            proxyLabelParts.SetFont(optionTabMain.fontName,scaledFloat);
            proxyLabelParts.Text = "アドレス:";

            proxyTBoxParts.Location = new Point(90, 60);
            proxyTBoxParts.Size = new Size(200, 16);
            proxyTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            portLabelParts.Location = new Point(300, 60);
            portLabelParts.Size = new Size(50, 20);
            portLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            portLabelParts.Text = "ポート:";

            portTBoxParts.Location = new Point(360, 60);
            portTBoxParts.Size = new Size(60, 16);
            portTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            proxyResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 60);
            proxyResetButtonParts.Size = new Size(100, 25);
            proxyResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            proxyResetButtonParts.Text = "元に戻す";

            tabPageParts.AddControl(proxyGBoxParts);

            proxyGBoxParts.AddControl(proxyCBoxParts);
            proxyGBoxParts.AddControl(proxyLabelParts);
            proxyGBoxParts.AddControl(proxyTBoxParts);
            proxyGBoxParts.AddControl(portLabelParts);
            proxyGBoxParts.AddControl(portTBoxParts);
            proxyGBoxParts.AddControl(proxyResetButtonParts);

            imageGBoxParts = new GroupBoxParts();
            jpgParts = new CheckBoxParts();
            pngParts = new CheckBoxParts();
            gifParts = new CheckBoxParts();
            bmpParts = new CheckBoxParts();

            imageGBoxParts.Location = new Point(10, 200);
            imageGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            imageGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageGBoxParts.Text = "画像抽出で画像とみなす拡張子";

            jpgParts.Location = new Point(20, 30);
            jpgParts.Size = new Size(60, 25);
            jpgParts.SetFont(optionTabMain.fontName, scaledFloat);
            jpgParts.Text = "jpeg";

            pngParts.Location = new Point(90, 30);
            pngParts.Size = new Size(60, 25);
            pngParts.SetFont(optionTabMain.fontName, scaledFloat);
            pngParts.Text = "png";

            gifParts.Location = new Point(160, 30);
            gifParts.Size = new Size(60, 25);
            gifParts.SetFont(optionTabMain.fontName, scaledFloat);
            gifParts.Text = "gif";

            bmpParts.Location = new Point(230, 30);
            bmpParts.Size = new Size(60, 25);
            bmpParts.SetFont(optionTabMain.fontName, scaledFloat);
            bmpParts.Text = "bmp";

            imageGBoxParts.AddControl(jpgParts);
            imageGBoxParts.AddControl(pngParts);
            imageGBoxParts.AddControl(gifParts);
            imageGBoxParts.AddControl(bmpParts);

            tabPageParts.AddControl(imageGBoxParts);         
            
            ///
            //logGboxParts = new GroupBoxParts();
            //logOpenLabelParts = new LabelParts();
            //logOpenTBoxParts = new TextBoxParts();
            //logOpenButtonParts = new ButtonParts();
            //logDefaultButtonParts = new ButtonParts();
            //saveWriteCBoxParts = new CheckBoxParts();

            //logGboxParts.Location = new Point(10, 200);
            //logGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 100);
            //logGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            //logGboxParts.Text = "ログやデータのフォルダ";

            //logOpenLabelParts.Location = new Point(20, 30);
            //logOpenLabelParts.Size = new Size(130, 20);
            //logOpenLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            //logOpenLabelParts.Text = "フォルダ:";

            //logOpenTBoxParts.Location = new Point(160, 30);
            //logOpenTBoxParts.Size = new Size(270, 16);
            //logOpenTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            //logOpenTBoxParts.ReadOnly = true;

            //logOpenButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            //logOpenButtonParts.Size = new Size(100, 25);
            //logOpenButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //logOpenButtonParts.Text = "フォルダを開く";

            //logDefaultButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 60);
            //logDefaultButtonParts.Size = new Size(100, 25);
            //logDefaultButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //logDefaultButtonParts.Text = "元に戻す";

            //saveWriteCBoxParts.Location = new Point(20, 60);
            //saveWriteCBoxParts.Size = new Size(160, 25);
            //saveWriteCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            //saveWriteCBoxParts.Text = "ログを保存しない：";

            //tabPageParts.AddControl(logGboxParts);
            //logGboxParts.AddControl(logOpenLabelParts);
            //logGboxParts.AddControl(logOpenTBoxParts);
            //logGboxParts.AddControl(logOpenButtonParts);
            //logGboxParts.AddControl(logDefaultButtonParts);
            //logGboxParts.AddControl(saveWriteCBoxParts);
            
            ///
            appGBoxParts = new GroupBoxParts();
            taskCBoxParts = new CheckBoxParts();
            saveCBoxParts = new CheckBoxParts();

            appGBoxParts.Location = new Point(10, 200);
            appGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            appGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            appGBoxParts.Text = "アプリケーションの動作";
            
            taskCBoxParts.Location = new Point(20, 30);
            taskCBoxParts.Size = new Size(300, 25);
            taskCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            taskCBoxParts.Text = "ウィンドウを最小化する時にタスクバーに格納する";

            saveCBoxParts.Location = new Point(20, 30);
            saveCBoxParts.Size = new Size(300, 25);
            saveCBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            saveCBoxParts.Text = "再起動時に、前回に開いていたページを再開する";

            //tabPageParts.AddControl(appGBoxParts);
            //appGBoxParts.AddControl(taskCBoxParts);
            //appGBoxParts.AddControl(saveCBoxParts);


            //モードのタイプ
            modeType2chGboxParts = new GroupBoxParts();
            mode2chRButtonParts = new RadioButtonParts();
            modeIERButtonParts = new RadioButtonParts();

            modeType2chGboxParts.Location = new Point(10, 280);
            modeType2chGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 70);
            modeType2chGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            modeType2chGboxParts.Text = "2chの表示モード";

            mode2chRButtonParts.Location = new Point(20, 30);
            mode2chRButtonParts.Size = new Size(120, 25);
            mode2chRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            mode2chRButtonParts.Text = "通常モード";

            modeIERButtonParts.Location = new Point(150, 30);
            modeIERButtonParts.Size = new Size(120, 25);
            modeIERButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            modeIERButtonParts.Text = "IEモード";

            modeIERButtonParts.Checked = true;

            modeType2chGboxParts.AddControl(mode2chRButtonParts);
            modeType2chGboxParts.AddControl(modeIERButtonParts);

            tabPageParts.AddControl(modeType2chGboxParts);

            //タブにタブページを加える
            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            otherOptionEvent = new OtherOptionEvent(this);
        }

        public void SetDataToGUI()
        {
            otherOptionEvent.ResetEvent();

            this.userAgentTBoxParts.Text = this.UserAgent;

            this.proxyCBoxParts.Checked = bool.Parse(this.IsProxyUse);
            this.proxyTBoxParts.Text = this.ProxyAddress;
            this.portTBoxParts.Text = this.ProxyPort;

            //this.logOpenTBoxParts.Text = this.LogFolder;
            //this.saveWriteCBoxParts.Checked = bool.Parse(this.IsWriteHistory);

            this.taskCBoxParts.Checked = bool.Parse(this.IsViewTaskBar);
            this.saveCBoxParts.Checked = bool.Parse(this.IsSaveOpenWindow);

            //画像抽出の拡張子
            this.jpgParts.Checked = bool.Parse(this.IsJpegImage);
            this.pngParts.Checked = bool.Parse(this.IsPngImage);
            this.gifParts.Checked = bool.Parse(this.IsGifImage);
            this.bmpParts.Checked = bool.Parse(this.IsBmpImage);

            if (this.ModeType2ch.Equals("IEMode") == true)
                this.modeIERButtonParts.Checked = true;
            else if (this.ModeType2ch.Equals("2chMode") == true)
                this.mode2chRButtonParts.Checked = true;

            otherOptionEvent.SetEvent();

        }
    }
}
