﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using nispi.OptionControl.OutWard.List;

namespace nispi.OptionControl
{
    partial class OutWardBrowser
    {
        public bool changeFlag = false;
        private OriginalFont originalFont = null;

        public void SetEvent()
        {
            this.browserFontButtonParts.Click += new EventHandler(browserFontButtonParts_Click);
            this.browserOriginalFontButtonParts.Click += new EventHandler(browserOriginalFontButtonParts_Click);
            this.browserBackColorButtonParts.Click += new EventHandler(browserBackColorButtonParts_Click);
            this.browserLinkColorButtonParts.Click += new EventHandler(browserLinkColorButtonParts_Click);
            this.browserLinkedColorButtonParts.Click += new EventHandler(browserLinkedColorButtonParts_Click);
            this.browserResetButtonParts.Click += new EventHandler(browserResetButtonParts_Click);
            this.simpleCBoxParts.SelectedIndexChanged += new EventHandler(simpleCBoxParts_SelectedIndexChanged);

            this.browserFontButtonParts.Click += new EventHandler(ChangeFlag);
            //this.browserOriginalFontButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserBackColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserLinkColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserLinkedColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserResetButtonParts.Click += new EventHandler(ChangeFlag);
            this.simpleCBoxParts.SelectedIndexChanged += new EventHandler(ChangeFlag);
        }

        public void ResetEvent()
        {
            this.browserFontButtonParts.Click -= new EventHandler(browserFontButtonParts_Click);
            this.browserOriginalFontButtonParts.Click -= new EventHandler(browserOriginalFontButtonParts_Click);
            this.browserBackColorButtonParts.Click -= new EventHandler(browserBackColorButtonParts_Click);
            this.browserLinkColorButtonParts.Click -= new EventHandler(browserLinkColorButtonParts_Click);
            this.browserLinkedColorButtonParts.Click -= new EventHandler(browserLinkedColorButtonParts_Click);
            this.browserResetButtonParts.Click -= new EventHandler(browserResetButtonParts_Click);
            this.simpleCBoxParts.SelectedIndexChanged -= new EventHandler(simpleCBoxParts_SelectedIndexChanged);

            this.browserFontButtonParts.Click -= new EventHandler(ChangeFlag);
            //this.browserOriginalFontButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserBackColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserLinkColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserLinkedColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserResetButtonParts.Click -= new EventHandler(ChangeFlag);
            this.simpleCBoxParts.SelectedIndexChanged -= new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        public void browserOriginalFontButtonParts_Click(object sender, EventArgs e)
        {
            originalFont = new OriginalFont(this.BrowserOriginalFontPath);
            originalFont.Show();
            originalFont.okButton.Click += new EventHandler(okButton_Click);

            FormFontSet formFontSet = new FormFontSet();
        }

        public void okButton_Click(object sender, EventArgs e)
        {
            FormFontSet formFontSet = new FormFontSet();

            try
            {
                //this.outWardOption.LVOriginalFontPath = originalFont.fontPath;
                //サイズを設定
                float a;
                if (float.TryParse(originalFont.sizeCBox.Text, out a) == true)
                    this.BrowserOriginalFontSize = float.Parse(originalFont.sizeCBox.Text);
                else
                    this.BrowserOriginalFontSize = 12.0f;

                this.browserOriginalFontPath = this.originalFont.fontPath;

                //フォントの名前を得る
                System.Drawing.Text.PrivateFontCollection pfc = new System.Drawing.Text.PrivateFontCollection();
                pfc.AddFontFile(originalFont.fontPath);
                Font temp = new Font(pfc.Families[0], 19.0f);
                this.BrowserOriginalFontName = temp.Name;


                this.tempBrowserForeColorRed = this.originalFont.colorSet.red;
                this.tempBrowserForeColorGreen = this.originalFont.colorSet.green;
                this.tempBrowserForeColorBlue = this.originalFont.colorSet.blue;

                this.BrowserFontType = "original";

                this.changeFlag = true;
                TempSetToGUI();
            }
            catch (System.IO.FileNotFoundException)
            {
                this.BrowserFontType = "installed";
            }
            catch
            {
                this.BrowserFontType = "installed";
            }
            originalFont.Dispose();
        }
        
        public void simpleCBoxParts_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.simpleCBoxParts.SelectedIndex == 0)
                this.tempBrowserType = "ageon";
            else
                this.tempBrowserType = "normal";

            TempSetToGUI();
        }
        //フォントのウィンドウを開く
        public void browserFontButtonParts_Click(object sender, EventArgs e)
        {
            FormFontSet formFontSet = new FormFontSet();
            if (true == FormGUI.GetFontData(formFontSet,this.BrowserFontName,this.BrowserFontSize,
                Color.FromArgb(this.BrowserForeColorRed,this.BrowserForeColorGreen,this.BrowserForeColorBlue)))
            {
                this.tempBrowserFontName = formFontSet.formFontName;
                this.tempBrowserFontSize = formFontSet.formFontSize;
                this.tempBrowserForeColorRed = formFontSet.formForeColorRed;
                this.tempBrowserForeColorGreen = formFontSet.formForeColorGreen;
                this.tempBrowserForeColorBlue = formFontSet.formForeColorBlue;

                this.BrowserFontType = "installed";
                TempSetToGUI();
            }
        }

        //背景色を得る
        public void browserBackColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                this.tempBrowserBackColorRed = colorSet.red;
                this.tempBrowserBackColorGreen = colorSet.green;
                this.tempBrowserBackColorBlue = colorSet.blue;

                TempSetToGUI();
            }
        }

        //フォントのウィンドウを開く
        public void browserLinkColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                this.tempBrowserLinkColorRed = colorSet.red;
                this.tempBrowserLinkColorGreen = colorSet.green;
                this.tempBrowserLinkColorBlue = colorSet.blue;

                TempSetToGUI();
            }
        }

        //背景色を得る
        public void browserLinkedColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                this.tempBrowserLinkedColorRed = colorSet.red;
                this.tempBrowserLinkedColorGreen = colorSet.green;
                this.tempBrowserLinkedColorBlue = colorSet.blue;

                TempSetToGUI();
            }
        }
        //リセットをする
        public void browserResetButtonParts_Click(object sender, EventArgs e)
        {
            this.tempBrowserFontName = Const.opt.fontNameStd;
            this.tempBrowserFontSize = Const.opt.fontSizeStd;

            this.tempBrowserForeColorRed = SystemColors.WindowText.R;
            this.tempBrowserForeColorGreen = SystemColors.WindowText.G;
            this.tempBrowserForeColorBlue = SystemColors.WindowText.B;

            this.tempBrowserBackColorRed = SystemColors.Window.R;
            this.tempBrowserBackColorGreen = SystemColors.Window.G;
            this.tempBrowserBackColorBlue = SystemColors.Window.B;

            this.tempBrowserLinkColorRed = 0;
            this.tempBrowserLinkColorGreen = 0;
            this.tempBrowserLinkColorBlue = 255;

            this.tempBrowserLinkedColorRed = 128;
            this.tempBrowserLinkedColorGreen = 0;
            this.tempBrowserLinkedColorBlue = 128;

            this.BrowserFontType = "installed";
            this.tempBrowserType = "ageon";

            TempSetToGUI();
        }

        public void TempSetToGUI()
        {
            this.ResetEvent();

            this.browserSampleParts.BrowserClear();

            string fontSize = this.tempBrowserFontSize.ToString();

            string backColor = Convert.ToString(this.tempBrowserBackColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserBackColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserBackColorBlue, 16).PadLeft(2, '0');

            string fontName = this.tempBrowserFontName;

            string foreColor = Convert.ToString(this.tempBrowserForeColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserForeColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserForeColorBlue, 16).PadLeft(2, '0');

            string linkColor = Convert.ToString(this.tempBrowserLinkColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserLinkColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserLinkColorBlue, 16).PadLeft(2, '0');

            string linkedColor = Convert.ToString(this.tempBrowserLinkedColorRed, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserLinkedColorGreen, 16).PadLeft(2, '0') +
                Convert.ToString(this.tempBrowserLinkedColorBlue, 16).PadLeft(2, '0');

            string pointX = "0";
            string pointY = "0";

            string htmlData = "";
            if (this.BrowserFontType.Equals("installed") == true)
            {
                htmlData = string.Format(HtmlTemplete.Header, fontSize, backColor, fontName, pointX, pointY);
            }
            else if (this.BrowserFontType.Equals("original") == true)
            {
                htmlData = string.Format(HtmlTemplete.HeaderOriginalFont, this.BrowserOriginalFontSize, backColor,this.BrowserOriginalFontName, this.BrowserOriginalFontPath, pointX, pointY);
            }

            htmlData += string.Format(@"<body color='#{0}' link='#{1}' vlink='#{2}'>", foreColor, linkColor, linkedColor);

            string comment = @"<font color='#" + foreColor + "'>書き込み内容</font><br>" +
                "<u><font color='" +
                linkColor +
                "'>未リンク</font></u>" +
                " <u><font color='#" +
                linkedColor +
                "'>既リンク</font></u>";
            if (this.tempBrowserType.Equals("ageon") == true)
                htmlData += string.Format(HtmlTemplete.AgeOnTheme1Sample ,linkColor, comment, foreColor);
            else
                htmlData += string.Format(HtmlTemplete.AgeOnTheme2Sample, linkColor, comment, foreColor);
            htmlData += "</body>";
            htmlData += "</html>";

            this.browserSampleParts.Write(htmlData);

            this.SetEvent();
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.BrowserFontName = this.tempBrowserFontName;
                    this.BrowserFontSize = this.tempBrowserFontSize;

                    this.BrowserForeColorRed = this.tempBrowserForeColorRed;
                    this.BrowserForeColorGreen = this.tempBrowserForeColorGreen;
                    this.BrowserForeColorBlue = this.tempBrowserForeColorBlue;

                    this.BrowserBackColorRed = this.tempBrowserBackColorRed;
                    this.BrowserBackColorGreen = this.tempBrowserBackColorGreen;
                    this.BrowserBackColorBlue = this.tempBrowserBackColorBlue;

                    this.BrowserLinkColorRed = this.tempBrowserLinkColorRed;
                    this.BrowserLinkColorGreen = this.tempBrowserLinkColorGreen;
                    this.BrowserLinkColorBlue = this.tempBrowserLinkColorBlue;

                    this.BrowserLinkedColorRed = this.tempBrowserLinkedColorRed;
                    this.BrowserLinkedColorGreen = this.tempBrowserLinkedColorGreen;
                    this.BrowserLinkedColorBlue = this.tempBrowserLinkedColorBlue;

                    this.BrowserType = this.tempBrowserType;

                    /*foreach (ThreadViewCommon tvc in MainFormConst.threadListTabMain.viewList)
                    {
                        tvc.SimpleReWrite();
                    }*/

                    this.SaveBrowserToFile();
                }
            }
        }
    }
}
