﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

namespace nispi.OptionControl
{
    partial class OutWardFormData : CommonInEvent
    {


        //private Font formFont;

        //private string formFontName;
        //private float formFontSize;

        private byte formForeColorRed;
        private byte formForeColorGreen;
        private byte formForeColorBlue;

        private byte formBackColorRed;
        private byte formBackColorGreen;
        private byte formBackColorBlue;


        private Mutex mutex = new Mutex(false, "OutWardFormData");

        public OutWardFormData()
        {
            GetXMLData();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "outward_form.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OutWard_Form";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                //FormFontName = doc2.Element(ns +  "FormFontName").Value;
                //FormFontSize = float.Parse(doc2.Element(ns + "FormFontSize").Value);

                FormForeColorRed = Byte.Parse(doc2.Element(ns + "FormForeColorRed").Value);
                FormForeColorGreen = Byte.Parse(doc2.Element(ns + "FormForeColorGreen").Value);
                FormForeColorBlue = Byte.Parse(doc2.Element(ns + "FormForeColorBlue").Value);

                FormBackColorRed = Byte.Parse(doc2.Element(ns + "FormBackColorRed").Value);
                FormBackColorGreen = Byte.Parse(doc2.Element(ns + "FormBackColorGreen").Value);
                FormBackColorBlue = Byte.Parse(doc2.Element(ns + "FormBackColorBlue").Value);    
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public string ResetXML()
        {
            XNamespace ns = "OutWard_Form";
            XElement doc = new XElement(ns + "Option",
                //new XElement(ns + "FormFontName", "Meiryo UI"),
                //new XElement(ns + "FormFontSize", "10.75"),

                new XElement(ns + "FormForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "FormForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "FormForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "FormBackColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "FormBackColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "FormBackColorBlue", SystemColors.Control.B.ToString()));

            FileIO.SaveShiftJis("setting", "outward_form.xml", doc.ToString());

            return doc.ToString();
        }

        public void SaveFormToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_Form";
            XElement doc = new XElement(ns + "Option",
                //new XElement(ns + "FormFontName", FormFontName),
                //new XElement(ns + "FormFontSize", FormFontSize.ToString()),

                new XElement(ns + "FormForeColorRed", FormForeColorRed.ToString()),
                new XElement(ns + "FormForeColorGreen", FormForeColorGreen.ToString()),
                new XElement(ns + "FormForeColorBlue", FormForeColorBlue.ToString()),

                new XElement(ns + "FormBackColorRed", FormBackColorRed.ToString()),
                new XElement(ns + "FormBackColorGreen", FormBackColorGreen.ToString()),
                new XElement(ns + "FormBackColorBlue", FormBackColorBlue.ToString()));

            FileIO.SaveShiftJis("setting", "outward_form.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public byte FormForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte FormForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte FormForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte FormBackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formBackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formBackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte FormBackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formBackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formBackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte FormBackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.formBackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.formBackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
 
    }
}
