﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using nispi.controlclass;

namespace nispi.OptionControl
{
    class OutWardEventTab
    {
        private OutWardTab outWardOption;
        public bool changeFlag = false;

        public OutWardEventTab(OutWardTab outWardOption)
        {
            this.outWardOption = outWardOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.outWardOption.tabForeColorButtonParts.Click += new EventHandler(tabForeColorButtonParts_Click);
            this.outWardOption.tabBackColorButtonParts.Click += new EventHandler(tabBackColorButtonParts_Click);

            this.outWardOption.tabSelectedColorButtonParts.Click += new EventHandler(tabSelectedColorButtonParts_Click);
            this.outWardOption.tabHotColorButtonParts.Click += new EventHandler(tabHotColorButtonParts_Click);

            this.outWardOption.tabResetButtonParts.Click += new EventHandler(tabResetButtonParts_Click);

            //チェンジイベント
            this.outWardOption.tabForeColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.tabBackColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.tabSelectedColorButtonParts.Click += new EventHandler(ChangeFlag);
            //this.outWardOption.tabColorEndButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.tabResetButtonParts.Click += new EventHandler(ChangeFlag);
        }
        public void ResetEvent()
        {
            this.outWardOption.tabForeColorButtonParts.Click -= new EventHandler(tabForeColorButtonParts_Click);
            this.outWardOption.tabBackColorButtonParts.Click -= new EventHandler(tabBackColorButtonParts_Click);

            this.outWardOption.tabSelectedColorButtonParts.Click -= new EventHandler(tabSelectedColorButtonParts_Click);
            this.outWardOption.tabHotColorButtonParts.Click -= new EventHandler(tabHotColorButtonParts_Click);

            this.outWardOption.tabResetButtonParts.Click -= new EventHandler(tabResetButtonParts_Click);

            //チェンジイベント
            this.outWardOption.tabForeColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.tabBackColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.tabSelectedColorButtonParts.Click -= new EventHandler(ChangeFlag);
            //this.outWardOption.tabColorEndButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.tabResetButtonParts.Click -= new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        //フォントのウィンドウを開く
        //サイズによってはタブの大きさを変える
        public void tabForeColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える。実データは書き換えない
                this.outWardOption.tabSampleTabControlParts.ForeColorP = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //キャプションウィンドウも作り変える


        //背景色を得る
        public void tabBackColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.sampleTabPageParts.BackColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
                this.outWardOption.sampleTabPagePartsTwo.BackColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }

        //タブの選択時の色
        public void tabSelectedColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.tabSampleTabControlParts.SelectedTabColorP = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //タブのマウスオーバー時の色
        public void tabHotColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.tabSampleTabControlParts.HotColorP = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //リセットをする
        public void tabResetButtonParts_Click(object sender, EventArgs e)
        {
            this.outWardOption.sampleTabPageParts.SetFont(outWardOption.optionTabMain.fontNameStd, outWardOption.optionTabMain.fontSizeStd);

            this.outWardOption.tabSampleTabControlParts.ForeColorP = SystemColors.WindowText;

            this.outWardOption.sampleTabPageParts.BackColor = SystemColors.Control;
            this.outWardOption.sampleTabPagePartsTwo.BackColor = SystemColors.Control;

            this.outWardOption.tabSampleTabControlParts.SelectedTabColorP = SystemColors.Control;

            this.outWardOption.tabSampleTabControlParts.HotColorP = SystemColors.Control;
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.outWardOption.TabFontName = this.outWardOption.sampleTabPageParts.GetFontName();
                    this.outWardOption.TabFontSize = this.outWardOption.sampleTabPageParts.GetFontSize();

                    this.outWardOption.TabForeColorRed = this.outWardOption.tabSampleTabControlParts.ForeColorP.R;
                    this.outWardOption.TabForeColorGreen = this.outWardOption.tabSampleTabControlParts.ForeColorP.G;
                    this.outWardOption.TabForeColorBlue = this.outWardOption.tabSampleTabControlParts.ForeColorP.B;

                    this.outWardOption.TabBackColorRed = this.outWardOption.sampleTabPageParts.BackColor.R;
                    this.outWardOption.TabBackColorGreen = this.outWardOption.sampleTabPageParts.BackColor.G;
                    this.outWardOption.TabBackColorBlue = this.outWardOption.sampleTabPageParts.BackColor.B;

                    this.outWardOption.TabSelectedColorRed = this.outWardOption.tabSampleTabControlParts.SelectedTabColorP.R;
                    this.outWardOption.TabSelectedColorGreen = this.outWardOption.tabSampleTabControlParts.SelectedTabColorP.G;
                    this.outWardOption.TabSelectedColorBlue = this.outWardOption.tabSampleTabControlParts.SelectedTabColorP.B;

                    this.outWardOption.TabHotColorRed = this.outWardOption.tabSampleTabControlParts.HotColorP.R;
                    this.outWardOption.TabHotColorGreen = this.outWardOption.tabSampleTabControlParts.HotColorP.G;
                    this.outWardOption.TabHotColorBlue = this.outWardOption.tabSampleTabControlParts.HotColorP.B;

                    this.outWardOption.SaveTabToFile();

                    //TabControlPartsManager.ChangeOutWard();
                }
            }
        }
    }
}
