﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

namespace nispi.OptionControl
{
    partial class OutWardMap : CommonInEvent
    {
        private byte mapSelectColorRed;
        private byte mapSelectColorGreen;
        private byte mapSelectColorBlue;

        private byte analysisColorRed;
        private byte analysisColorGreen;
        private byte analysisColorBlue;

        private string gradationColor;

        private string tempGradationColor;


        private Mutex mutex = new Mutex(false, "OutWardMapData");

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "outward_map.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OutWard_Map";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                MapSelectColorRed = Byte.Parse(doc2.Element(ns + "MapSelectColorRed").Value);
                MapSelectColorGreen = Byte.Parse(doc2.Element(ns + "MapSelectColorGreen").Value);
                MapSelectColorBlue = Byte.Parse(doc2.Element(ns + "MapSelectColorBlue").Value);

                AnalysisColorRed = Byte.Parse(doc2.Element(ns + "AnalysisColorRed").Value);
                AnalysisColorGreen = Byte.Parse(doc2.Element(ns + "AnalysisColorGreen").Value);
                AnalysisColorBlue = Byte.Parse(doc2.Element(ns + "AnalysisColorBlue").Value);

                GradationColor = doc2.Element(ns + "GradationColor").Value;
                tempGradationColor = this.GradationColor;
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public string ResetXML()
        {
            XNamespace ns = "OutWard_Map";
            XElement doc = new XElement(ns + "Option",
                
                new XElement(ns + "MapSelectColorRed", "0"),
                new XElement(ns + "MapSelectColorGreen", "0"),
                new XElement(ns + "MapSelectColorBlue", "255"),

                new XElement(ns + "AnalysisColorRed", "255"),
                new XElement(ns + "AnalysisColorGreen", "255"),
                new XElement(ns + "AnalysisColorBlue", "255"),
                
                new XElement(ns + "GradationColor", "Red"));

            FileIO.SaveShiftJis("setting", "outward_map.xml", doc.ToString());

            return doc.ToString();
        }

        public void SaveFormToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_Map";
            XElement doc = new XElement(ns + "Option",

                new XElement(ns + "MapSelectColorRed", MapSelectColorRed.ToString()),
                new XElement(ns + "MapSelectColorGreen", MapSelectColorGreen.ToString()),
                new XElement(ns + "MapSelectColorBlue", MapSelectColorBlue.ToString()),

                new XElement(ns + "AnalysisColorRed", AnalysisColorRed.ToString()),
                new XElement(ns + "AnalysisColorGreen", AnalysisColorGreen.ToString()),
                new XElement(ns + "AnalysisColorBlue", AnalysisColorBlue.ToString()),
                
                new XElement(ns + "GradationColor", GradationColor));

            FileIO.SaveShiftJis("setting", "outward_map.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public byte MapSelectColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.mapSelectColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.mapSelectColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MapSelectColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.mapSelectColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.mapSelectColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MapSelectColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.mapSelectColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.mapSelectColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte AnalysisColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.analysisColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.analysisColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte AnalysisColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.analysisColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.analysisColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte AnalysisColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.analysisColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.analysisColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string GradationColor
        {
            set
            {
                mutex.WaitOne();
                this.gradationColor = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.gradationColor);
                mutex.ReleaseMutex();
                return data;
            }
        }
    }
}
