﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
namespace nispi.OptionControl
{
    //選択色、解析の色調（コンボボックス）

    partial class OutWardMap
    {
        public TabPageExParts tabPageParts;
        GroupBoxParts mapGBoxParts;

        //選択の際の色
        public LabelParts mapSelectSampleLabelParts;
        public ButtonParts mapSelectColorButtonParts;
        //解析の色
        public LabelParts analysisSampleLabelParts;
        public ButtonParts analysisColorButtonParts;

        public PictureBoxParts analysisGradationPicBoxParts;
        public LabelParts analysisGradTextLabelParts;

        public RadioButtonParts analysisRedRButtonParts;
        public RadioButtonParts analysisGreenRButtonParts;
        public RadioButtonParts analysisBlueRButtonParts;

        public ButtonParts mapResetButtonParts;

        public OptionMainForm optionTabMain;

        public OutWardMap(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            mapGBoxParts = new GroupBoxParts();
            mapGBoxParts.Enabled = false;

            mapSelectSampleLabelParts = new LabelParts();
            mapSelectColorButtonParts = new ButtonParts();

            analysisSampleLabelParts = new LabelParts();

            analysisColorButtonParts = new ButtonParts();

            analysisGradationPicBoxParts = new PictureBoxParts();
            analysisGradTextLabelParts = new LabelParts();

            analysisRedRButtonParts = new  RadioButtonParts();
            analysisGreenRButtonParts = new  RadioButtonParts();
            analysisBlueRButtonParts = new  RadioButtonParts();

            mapResetButtonParts = new ButtonParts();

            tabPageParts = new  TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "外観2 ";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            mapGBoxParts.Location = new Point(10, 10);
            mapGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 130);
            mapGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            mapGBoxParts.Text = "地図による解析";

            mapSelectSampleLabelParts.Location = new Point(20, 30);
            mapSelectSampleLabelParts.Size = new Size(200, 25);
            mapSelectSampleLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            mapSelectSampleLabelParts.Text = "";
            mapSelectSampleLabelParts.BackColor = SystemColors.Control;
            mapSelectSampleLabelParts.ForeColor = SystemColors.WindowText;
            mapSelectSampleLabelParts.Set_BorderStyle_FixedSingle();

            mapSelectColorButtonParts.Location = new Point(230, 30);
            mapSelectColorButtonParts.Size = new Size(200, 25);
            mapSelectColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            mapSelectColorButtonParts.Text = "選択の際の色";

            /////解析用
            analysisSampleLabelParts.Location = new Point(20, 60);
            analysisSampleLabelParts.Size = new Size(200, 25);
            analysisSampleLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisSampleLabelParts.Text = "";
            analysisSampleLabelParts.BackColor = SystemColors.Control;
            analysisSampleLabelParts.ForeColor = SystemColors.WindowText;
            analysisSampleLabelParts.Set_BorderStyle_FixedSingle();

            analysisColorButtonParts.Location = new Point(230, 60);
            analysisColorButtonParts.Size = new Size(200, 25);
            analysisColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisColorButtonParts.Text = "解析用の色";

            //グラデーションの選択
            analysisGradationPicBoxParts.Location = new Point(20, 90);
            analysisGradationPicBoxParts.Size = new Size(200, 25);
            analysisGradationPicBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisGradationPicBoxParts.Text = "";
            analysisGradationPicBoxParts.BackColor = SystemColors.Control;
            analysisGradationPicBoxParts.ForeColor = SystemColors.WindowText;
            //analysisGradationPicBoxParts.Set_BorderStyle_FixedSingle();

            analysisGradTextLabelParts.Location = new Point(230, 90);
            analysisGradTextLabelParts.Size = new Size(120, 25);
            analysisGradTextLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisGradTextLabelParts.Text = "ｸﾞﾗﾃﾞｰｼｮﾝする色";
            //analysisGradTextLabelParts.Set_BorderStyle_FixedSingle();


            analysisRedRButtonParts.Location = new Point(360, 90);
            analysisRedRButtonParts.Size = new Size(40, 25);
            analysisRedRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisRedRButtonParts.Text = "1";

            analysisGreenRButtonParts.Location = new Point(410, 90);
            analysisGreenRButtonParts.Size = new Size(40, 25);
            analysisGreenRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisGreenRButtonParts.Text = "2";

            analysisBlueRButtonParts.Location = new Point(460, 90);
            analysisBlueRButtonParts.Size = new Size(40, 25);
            analysisBlueRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            analysisBlueRButtonParts.Text = "3";


            mapResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            mapResetButtonParts.Size = new Size(100, 25);
            mapResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            mapResetButtonParts.Text = "元に戻す";
            
            //tabPageParts.AddControl(mapGBoxParts);
            mapGBoxParts.AddControl(mapSelectSampleLabelParts);
            mapGBoxParts.AddControl(mapSelectColorButtonParts);

            mapGBoxParts.AddControl(analysisColorButtonParts);

            mapGBoxParts.AddControl(analysisSampleLabelParts);

            //グラデーション
            mapGBoxParts.AddControl(analysisGradationPicBoxParts);
            mapGBoxParts.AddControl(analysisGradTextLabelParts);
            mapGBoxParts.AddControl(analysisRedRButtonParts);
            mapGBoxParts.AddControl(analysisGreenRButtonParts);
            mapGBoxParts.AddControl(analysisBlueRButtonParts);

            mapGBoxParts.AddControl(mapResetButtonParts);

            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            this.GetXMLData();
            this.SetEvent();
        }

        public void SetDataToGUI()
        {
            this.ResetEvent();

            //塗りつぶす色
            this.mapSelectSampleLabelParts.BackColor = Color.FromArgb(this.MapSelectColorRed,
                this.MapSelectColorGreen,
                this.MapSelectColorBlue);

            //グラデーションの基本色
            this.analysisSampleLabelParts.BackColor = Color.FromArgb(this.AnalysisColorRed,
                 this.AnalysisColorGreen,
                 this.AnalysisColorBlue);

            //グラデーションする色
            if (this.GradationColor.Equals("Red") == true)
                this.analysisRedRButtonParts.Checked = true;
            else if (this.GradationColor.Equals("Green") == true)
                this.analysisGreenRButtonParts.Checked = true;
            else
                this.analysisBlueRButtonParts.Checked = true;

            this.analysisGradationPicBoxParts.Image = MakeGradationImage(this.AnalysisColorRed,
                this.AnalysisColorGreen,
                this.AnalysisColorBlue,
                this.GradationColor);

            this.SetEvent();
        }
    }
}
