﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Xml.Linq;
using System.IO;

namespace nispi.OptionControl
{
    class BrowserOptionData : CommonInEvent
    {
        public string imageBrower;
        public string imageBrowserFile;

        public string linkBrowser;
        public string linkBrowserFile;

        public static readonly string IMAGEBROWSER = "usually";
        public static readonly string IMAGEBROWSERFILE = "none";
        public static readonly string LINKBROWSER = "usually";
        public static readonly string LINKBROWSERFILE = "none";

        private Mutex mutex = new Mutex(false, "BrowserOptionData");

        public BrowserOptionData()
        {
            GetXMLData();
        }
        public string ResetXML()
        {
            mutex.WaitOne();

            XNamespace ns = "BrowserOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "ImageBrowser", IMAGEBROWSER),
                new XElement(ns + "ImageBrowserFile", IMAGEBROWSERFILE),
                new XElement(ns + "LinkBrowser", LINKBROWSER),
                new XElement(ns + "LinkBrowserFile", LINKBROWSERFILE));

            FileIO.SaveShiftJis("setting", "browser.xml", doc.ToString());

            mutex.ReleaseMutex();

            return doc.ToString();
        }
        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "browser.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "BrowserOptionData";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                this.ImageBrowser = doc2.Element(ns + "ImageBrowser").Value;
                string tempImageBrowserFile = doc2.Element(ns + "ImageBrowserFile").Value;
                this.LinkBrowser = doc2.Element(ns + "LinkBrowser").Value;
                string tempLinkBrowserFile = doc2.Element(ns + "LinkBrowserFile").Value;

                //フォルダーの行が?current:で始まっている場合
                if (tempImageBrowserFile.StartsWith("?current:") == true)
                {
                    string temp = tempImageBrowserFile.Substring(9, tempImageBrowserFile.Length - 9);
                    this.ImageBrowserFile = Const.CurrentDir + Path.DirectorySeparatorChar + temp;
                }
                else
                    this.ImageBrowserFile = tempImageBrowserFile;

                //フォルダーの行が?current:で始まっている場合
                if (tempLinkBrowserFile.StartsWith("?current:") == true)
                {
                    string temp = tempLinkBrowserFile.Substring(9, tempLinkBrowserFile.Length - 9);
                    this.LinkBrowserFile = Const.CurrentDir + Path.DirectorySeparatorChar + temp;
                }
                else
                    this.LinkBrowserFile = tempLinkBrowserFile;
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public void SaveToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "BrowserOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "ImageBrowser", this.ImageBrowser),
                new XElement(ns + "ImageBrowserFile", this.ImageBrowserFile),
                new XElement(ns + "LinkBrowser", this.LinkBrowser),
                new XElement(ns + "LinkBrowserFile", this.LinkBrowserFile));

            FileIO.SaveShiftJis("setting", "browser.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public string ImageBrowser
        {
            set
            {
                mutex.WaitOne();
                if (CheckTypeData(value) == false)
                    this.imageBrower = IMAGEBROWSER;
                else
                    this.imageBrower = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.imageBrower);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string ImageBrowserFile
        {
            set
            {
                mutex.WaitOne();
                
                if (CheckFile(value) == false)
                {
                    this.imageBrowserFile = IMAGEBROWSERFILE;
                }
                else
                    this.imageBrowserFile = value;

                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.imageBrowserFile);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string LinkBrowser
        {
            set
            {                
                mutex.WaitOne();
                
                if (CheckTypeData(value) == false)
                    this.linkBrowser = LINKBROWSER;
                else
                    this.linkBrowser = value;
                
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.linkBrowser);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string LinkBrowserFile
        {
            set
            {
                mutex.WaitOne();

                if (CheckFile(value) == false)
                {
                    this.linkBrowserFile = LINKBROWSERFILE;
                }
                else
                    this.linkBrowserFile = value;

                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.linkBrowserFile);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public bool CheckTypeData(string data)
        {
            try
            {
                if ((data.Equals("usually") == true) ||
                (data.Equals("ageon") == true) ||
                (data.Equals("file") == true) ||
                (data.Equals("notopen") == true))
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }
    }
}