﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.IO;
//using System.Threading.Tasks;

//メインフォームがクローズされるときに保存。
//BoardIndexViewにてRead()を行っている

namespace nispi.SaveBoardAndThread
{
    class SaveBoard
    {
        public SaveBoard()
        {
        }

        public void Save(List<BoardViewCommon> list)
        {
            string ns = "SaveBoardList";

            XmlDocument doc = new XmlDocument();
            XmlElement saveBoardList = doc.CreateElement("SaveBoardList", ns);
            doc.AppendChild(saveBoardList);


            foreach (BoardViewCommon boardView in list)
            {
                if (boardView.board_url == null) break;
                //お気に入りのタブは他で開くのでスルーする
                if (boardView.board_url.Equals("local://favorite/thread") == true)
                    continue;
                
                //エレメントを作成
                XmlElement boardAddress = doc.CreateElement("BoardAddress", ns);
                //内部にAddressを作成し値をセット
                boardAddress.SetAttribute("Address", boardView.board_url);
                boardAddress.InnerText = BoardDataBase.GetName(boardView.board_url);
                
                //お気に入りのデータベースも照合
                if (boardAddress.InnerText.Length == 0)
                {
                    boardAddress.InnerText = FavoriteBoardDataBase.GetName(boardView.board_url, Util.BoardUrlToBoardTypeName(boardView.board_url)) + " ";
                }

                //SaveBoardListの下位に加える
                saveBoardList.AppendChild(boardAddress);
            }

            FileIO.SaveShiftJis("setting", "SaveBoardList.xml", doc.OuterXml);
        }

        delegate void ShowBoardDelegate(string address,  bool b);

        public void Read()
        {
            string str = FileIO.ReadShiftJis("setting", "SaveBoardList.xml");
            if ((str == null) || (str.Length == 0)) return;

            XmlDocument dom = new XmlDocument();
            dom.LoadXml(str);

            foreach (XmlElement node in dom.GetElementsByTagName("BoardAddress", "SaveBoardList"))
            {
                //Addressの値を得る
                string address = node.Attributes["Address"].Value;
                string name = node.InnerText;
                string boardUrl;

                //したらばの場合はアドレスをそのまま使用する
                if (Util.BoardType(address) == Util.TYPE_JBBS)
                {
                    boardUrl = address;
                }
                //したらば以外は名前とタイプからアドレスを辞書で引く
                else
                {
                    //Addressの板をタブで開く
                    string temp = Util.BoardUrlToBoardTypeName(address);
                    string temp2 = Util.BoardUrlToBoardID(address);
                    if ((temp == null) || (temp.Length == 0) || (temp2 == null) || (temp2.Length == 0))
                        continue;
                    boardUrl = BoardDataBase.GetUrl(temp, temp2);
                    //string a;
                    if ((boardUrl == null) || (boardUrl.Length == 0))
                    {
                        continue;
                    }
                }
                //a = "";

                Const.form.mainForm.Invoke(new ShowBoardDelegate(
                    MainFormConst.boardListTabMain.show_board), boardUrl, true);
            }
            //Const.form.mainForm.Invoke((Action)(() => Const.form.boardListTabControlParts.SelectedIndex = 0));
        }
    }
}
