﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

namespace nispi
{
    static class FileIO
    {
        public static bool CheckIsFile(string dir)
        {
            if (System.IO.File.Exists(dir) == false)
            {
                return false;
            }
            return true;
        }


        public static string GetDirFromParam(params string[] line)
        {
            string folders = "";
            foreach (string data in line)
                folders += data + Path.DirectorySeparatorChar;
            return Const.DataDir + Path.DirectorySeparatorChar + folders;
        }

        public static bool CheckIsFolder(string dir)
        {
            if (System.IO.Directory.Exists(dir) == false)
            {
                return false;
            }
            return true;
        }

        public static void SaveUnicode(string dir, string file, string str)
        {
            dir = Const.DataDir + Path.DirectorySeparatorChar + dir;
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            try
            {
                using (FileStream fsw = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Create))
                {
                    using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.Unicode))
                    {
                        sw.Write(str);
                        sw.Flush();
                        sw.Close();
                        fsw.Close();
                    }
                }
            }
            catch
            {
                return;
            }
        }
        public static void SaveAddUnicode(string dir, string file, string str)
        {
            dir = Const.DataDir + Path.DirectorySeparatorChar + dir;
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }
            try
            {
                using (FileStream fsw = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Append))
                {
                    using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.Unicode))
                    {
                        sw.Write(str);
                        sw.Flush();
                        sw.Close();
                        fsw.Close();
                    }
                }
            }
            catch
            {
                return;
            }
        }
        public static void SaveShiftJis(string dir, string file, string str)
        {
            dir = Const.DataDir + Path.DirectorySeparatorChar + dir;
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new DirectoryInfo(dir);
                di.Create();
            }

            try
            {
                using (FileStream fsw = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Create))
                {
                    using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.GetEncoding("shift-jis")))
                    {
                        sw.Write(str);
                        sw.Flush();
                        sw.Close();
                        fsw.Close();
                    }
                }
            }
            catch
            {
                return;
            }
        }

        public static string ReadUnicode(string dir, string file)
        {
            dir = Const.DataDir + Path.DirectorySeparatorChar + dir;
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new DirectoryInfo(dir);
                di.Create();
            }

            file = dir + Path.DirectorySeparatorChar + file;
            if (File.Exists(file) == false)
            {
                return "";
            }

            string str = "";
            try
            {
                using (FileStream fs = new FileStream(file, FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(fs, System.Text.Encoding.Unicode))
                    {
                        str = sr.ReadToEnd();
                        sr.Close();
                        fs.Close();
                    }

                    return str;
                }
            }
            catch
            {
                return str;
            }
        }

        public static string ReadShiftJis(string dir, string file)
        {
            dir = Const.DataDir + Path.DirectorySeparatorChar + dir;
            
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new DirectoryInfo(dir);
                di.Create();
            }

            file = dir + Path.DirectorySeparatorChar + file;
            if (File.Exists(file) == false)
            {
                return "";
            }

            string str = "";

            try
            {
                using (FileStream fsr = new FileStream(file, FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(fsr, System.Text.Encoding.GetEncoding("shift-jis")))
                    {
                        string data = sr.ReadToEnd();
                        sr.Close();
                        fsr.Close();
                        return data;
                    }

                }
            }
            catch
            {
                return str;
            }
        }
        public static string ReadCurrentShiftJis(string dir, string file)
        {
            dir = Const.CurrentDir + Path.DirectorySeparatorChar + dir;
            string str = "";

            try
            {
                using (FileStream fsr = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(fsr, System.Text.Encoding.GetEncoding("shift-jis")))
                    {
                        string data = sr.ReadToEnd();
                        sr.Close();
                        fsr.Close();
                        return data;
                    }
                }
            }
            catch
            {
                return str;
            }
        }
        public static void SaveToSubjectList(List<ThreadData> threadList, string boardType, string boardID, string fileName)
        {
            StringBuilder sb = new StringBuilder();

            foreach (ThreadData threadData in threadList)
            {
                sb.Append(SubjectUtil.MakeSubjectInfoLine(threadData));
            }
            FileIO.SaveUnicode(
                ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar +
                boardType + Path.DirectorySeparatorChar +
                boardID, fileName, sb.ToString());
            
            //sb.Clear();
        }
    }
}
