/*
 * encode decode routine used for control.
 *
 * $Id: dencode.c,v 1.2 2002/03/26 10:46:59 taka Exp $
 */
#include "dencode.h"

void
encode (const char* from, char* to)
{
	while (*from) {
		switch (*from) {
		case '\n':
			*to++ = '\\';
			*to++ = 'n';
			from ++;
			break;
		case '\\':
			*to++ = '\\';
			*to++ = *from++;
			break;
		default:
			*to++ = *from++;
			break;
		}
	}
	*to = *from;
}

void
decode (const char* from, char* to)
{
	while (*from) {
		if (*from == '\\') {
			switch (*++from) {
			case 'n':
				*to++ = '\n';
				from++;
				break;
			case '\\':
			default:
				*to++ = *from++;
				break;
			}
		} else {
			*to++ = *from++;
		}
	}
	*to = *from;
}
