/*
 * $Id: aime.h,v 1.18 2002/03/26 10:46:59 taka Exp $
 */
#ifndef AIME_H_INCLUDED
#define AIME_H_INCLUDED
enum
{
	INPUT_MODE_H_ASCII,
	INPUT_MODE_HIRAGANA,
	INPUT_MODE_KATAKANA,
	INPUT_MODE_Z_ASCII,
	INPUT_MODE_KANA,
	INPUT_MODE_NUM,
};

enum
{
	FD_WATCH_READ  = 1 << 0,
	FD_WATCH_WRITE = 1 << 1,
};
int
add_fd_watch (int fd, int type, void (*func)(int,void*), void* data);
void
del_fd_watch (int fd);


extern int option_flg;
extern int debug_mode;
extern int disable_on_the_spot;

#ifdef __GNUC__
int
debug_printf (const char* format, ...)
	__attribute__ ((format (__printf__, 1, 2)));
#define DPRINTF(format, ...) do {					\
		if (debug_mode) debug_printf (format, ##__VA_ARGS__);	\
	} while (0)
#else
int
debug_printf (const char* format, ...);
#define DPRINTF debug_printf
#endif

int
error_printf (const char* format, ...);
#define NOMEMORY(x) do {						\
		error_printf ("NOMEM: %s:%d %s\n", __FILE__, __LINE__, x); \
	}while (0)

#ifdef DEBUG
void*
malloc_wrapper (int x);
void*
realloc_wrapper (void* p, int x);
void*
strdup_wrapper (const char* p);
void
free_wrapper (void* x);
#define malloc(x) malloc_wrapper(x)
#define realloc(x,s) realloc_wrapper(x,s)
#define strdup(x) strdup_wrapper(x)
#define free(x) free_wrapper(x)
#endif

#define PAD4(v) ((4 - ((v) % 4)) % 4)
#define NUMBER_OF_ELEMENTS(x) (sizeof (x) / sizeof ((x)[0]))

#endif  /* AIME_H_INCLUDED */
