/*
 * deal charcode
 *
 * $Id: charcode.c,v 1.7 2002/03/26 10:46:59 taka Exp $
 */

#include <string.h>
#include "charcode.h"

int
eucjp2ctext (const char* src, char* dst)
{
	enum
	{
		CHARSET_DUMMY,
		CHARSET_ASCII,
		CHARSET_JISX0201_1976R,
		CHARSET_JISX0208_1983,
	};
	int current_code = CHARSET_DUMMY;
	int c;
	int len = 0;

	while (*src) {
		if (*src & 0x80) {
			c = *src ++;
			if (!*src) break;

			switch (c) {
			case 0x8E:
				if (current_code != CHARSET_JISX0201_1976R) {
					if (dst) {
						/* JISX0201_1976 -> GR */
						*dst++ = 0x1B;
						*dst++ = ')'; /* 02/09 */
						*dst++ = 'I'; /* 04/09 */
					}
					current_code = CHARSET_JISX0201_1976R;
					len += 3;
				}
				if (dst) {
					*dst++ = *src;
				}
				len += 1;
				src++;
				break;
			case 0x8F:
				/* what should I do? */
				src += 2;
				break;
			default:
				if (current_code != CHARSET_JISX0208_1983) {
					if (dst) {
						/* JISX0208_1983 -> GR */
						*dst++ = 0x1B;
						*dst++ = '$'; /* 02/04 */
						*dst++ = ')'; /* 02/09 */
						*dst++ = 'B'; /* 04/02 */
					}
					current_code = CHARSET_JISX0208_1983;
					len += 4;
				}

				if (dst) {	
					*dst++ = c;
					*dst++ = *src;
				}
				len += 2;
				src++;
				break;
			}
		} else {
			c = *src;
			if (c >= 0x20 && c <= 0x7F) {
				if (current_code != CHARSET_ASCII) {
					if (dst) {
						/* ASCII -> GL */
						*dst++ = 0x1B;
						*dst++ = '('; /* 02/08 */
						*dst++ = 'B'; /* 04/02 */
					}
					current_code = CHARSET_ASCII;
					len += 3;
				}
			}
			if (dst) {
				*dst++ = c;
			}
			len += 1;
			src++;
		}
	}
	return len;
}

int
eucjp_next (const char* src)
{
	int c;

	if (*src == '\0') return 0;
	if (*src & 0x80) {
		c = *src++;
		if (!*src) return 1;

		switch (c) {
		case 0x8F:
			if (!*src++) {
				return 2;
			} else {
				return 3;
			}
			break;
		default:
			return 2;
			break;
		}
	} else {
		return 1;
	}
}

int
eucjp_last (const unsigned char* buf, int len)
{
	if (len <= 0) return 0;
	else if (len == 1) return 1;
	else if (len == 2)
		if (*(buf-2) & 0x80) return 2;
		else                 return 1;
	else
		if (*(buf-3) == 0x8F)     return 3;
		else if (*(buf-2) & 0x80) return 2;
		else                      return 1;
}

int
eucjp_len (unsigned char* src)
{
	int len = 0;
	int c;

	while (*src) {
		if (*src & 0x80) {
			c = *src ++;
			if (!*src) break;

			switch (c) {
			case 0x8F:
				src += 2;
				break;
			default:
				src++;
				break;
			}
		} else {
			src++;
		}
		len += 1;
	}
	return len;
}
