/*
 * command control
 *
 * this routine is copyed from OpenBSD:/usr/src/sys/net/pf.c
 *
 * $Id: cmd.c,v 1.6 2002/03/26 10:46:59 taka Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "control.h"
#include "aime.h"
#include "hotkeys.h"
#include "cmd.h"

static void
cmd_write (const char* format, ...)
#ifdef __GNUC__
	__attribute__ ((format (__printf__, 1, 2)));
#else /* __GNUC__ */
	;
#endif
static void
cmd_write (const char* format, ...)
{
	char buffer[512];
	va_list arg;

	va_start (arg, format);
	vsnprintf (buffer, sizeof (buffer), format, arg);
	va_end (arg);

	control_write (buffer);
}

static int
echo_func (const char* buf)
{
	control_write (buf);
	return 1;
}
struct command_table
{
	const char*	cmdname;

	/* return 1 if succeeded, otherwise return 0 */
	int (*func) (const char* buf);
};
static struct command_table command_list[] = {
	{"echo",   echo_func},
	{"setkey", setkey_func},
};

/*	$OpenBSD: pf.c,v 1.161 2001/10/02 08:44:21 dhartmei Exp $ */

/*
 * Copyright (c) 2001 Daniel Hartmeier
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
struct command_table_node
{
	struct command_table* cmdtab;

	struct command_table_node* parent;
	struct command_table_node* left;
	struct command_table_node* right;
	int balance;
};
static struct command_table_node* cmd_table_tree;

static void
tree_left (struct command_table_node** n)
{
	struct command_table_node* q = *n;
	struct command_table_node* p = (*n)->parent;

	(*n)->parent = (*n)->right;
	*n = (*n)->right;
	(*n)->parent = p;
	q->right = (*n)->left;
	if (q->right) q->right->parent = q;
	(*n)->left = q;
	q->balance --;
	if ((*n)->balance > 0) q->balance -= (*n)->balance;
	(*n)->balance --;
	if (q->balance < 0) (*n)->balance += q->balance;
}
static void
tree_right (struct command_table_node** n)
{
        struct command_table_node* q = *n;
	struct command_table_node* p = (*n)->parent;

	(*n)->parent = (*n)->left;
	*n = (*n)->left;
	(*n)->parent = p;
	q->left = (*n)->right;
	if (q->left) q->left->parent = q;
	(*n)->right = q;
	q->balance ++;
	if ((*n)->balance < 0) q->balance -= (*n)->balance;
	(*n)->balance ++;
	if (q->balance > 0) (*n)->balance += q->balance;
}

static int
tree_compare (struct command_table* c1, struct command_table* c2)
{
	return strcmp (c1->cmdname, c2->cmdname);
}

static int
tree_insert (struct command_table_node** n, struct command_table_node* p,
	     struct command_table* cmd)
{
	int d = 0;

	if (*n == NULL) {
		*n = malloc (sizeof (struct command_table_node));
		if (*n == NULL) return -1;
		(*n)->balance = 0;
		(*n)->parent = p;
		(*n)->left = (*n)->right = NULL;
		(*n)->cmdtab = cmd;
		d = 1;

	} else if (tree_compare (cmd, (*n)->cmdtab) > 0) {
		if (tree_insert (&(*n)->right, *n, cmd)) {
			(*n)->balance ++;
			if ((*n)->balance == 1) d = 1;
			else if ((*n)->balance == 2) {
				if ((*n)->right->balance == -1) {
					tree_right (&(*n)->right);
				}
				tree_left (n);
			}
		}

	} else {
		if (tree_insert (&(*n)->left, *n, cmd)) {
			(*n)->balance --;
			if ((*n)->balance == -1) d = 1;
			else if ((*n)->balance == -2) {
				if ((*n)->left->balance == 1) {
					tree_left (&(*n)->left);
				}
				tree_right (n);
			}
		}
	}
	return d;
}

#if 0
static struct command_table_node*
tree_first (struct command_table_node* n)
{
        if (n == NULL) return NULL;
        while (n->parent) n = n->parent;
        while (n->left) n = n->left;
        return n;
}

static struct command_table_node*
tree_next(struct command_table_node* n)
{
        if (n == NULL) return NULL;
        if (n->right) {
                n = n->right;
                while (n->left) n = n->left;
        } else {
                if (n->parent && (n == n->parent->left)) n = n->parent;
		else {
                        while (n->parent && (n == n->parent->right)) {
                                n = n->parent;
			}
                        n = n->parent;
                }
        }
        return n;
}
#endif

static struct command_table*
cmd_search (struct command_table_node* tree, char* name)
{
	int ret;

	if (tree == NULL) return NULL;

	ret = strcmp (name, tree->cmdtab->cmdname);
	if (ret == 0)     return tree->cmdtab;
	else if (ret > 0) return cmd_search (tree->right, name);
	else              return cmd_search (tree->left, name);
}

int
cmd_init (void)
{
	int i;
	for (i = 0; i < NUMBER_OF_ELEMENTS (command_list); i++) {
		tree_insert (&cmd_table_tree, NULL, &command_list[i]);
	}
	return 0;
}

int
cmd_exec (const char* buf)
{
	const char* s = buf;
	char* c;
	char	command[128];
	int i;
	struct command_table* n;

	c = command;
	for (i = 0; *s && i < sizeof (command); i++) {
		*c++ = *s++;
		if (*s == ' ' || *s == '\t') {
			*c = '\0';
			s ++;
			break;
		}
	}
	*c = '\0';
	
	n = cmd_search (cmd_table_tree, command);
	if (n == NULL) {
		cmd_write ("ERR:no such command %s", command);
		return -1;
	}

	return n->func (s);
}
