/*
 * deal hotke
 *
 * $Id: hotkeys.c,v 1.10 2002/03/26 10:46:59 taka Exp $
 */
#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

#include "queue.h"
#include "ximpacket.h"
#include "ximic.h"
#include "conversion.h"
#include "hotkeys.h"
#include "aime.h"
#include "bufsize.h"
#include "conversion.h"

struct hotkey
{
	int	state;
	KeySym	ksym;

	int	hktype;

	SLIST_ENTRY(hotkey) entry;
};
struct hotkeys
{
	SLIST_HEAD (,hotkey) keys;
};

struct hotkeys*
hotkeys_allocate (void)
{
	struct hotkeys* hk;

	hk = malloc (sizeof (struct hotkeys));
	if (hk == NULL) {
		NOMEMORY ("can't allocate hotkey");
		return NULL;
	}
	SLIST_INIT (&hk->keys);

	return hk;
}
void
hotkeys_destroy (struct hotkeys* hk)
{
	hotkeys_removeall (hk);
	free (hk);
}

int
hotkeys_get_type (struct hotkeys* hk, int state, KeySym ksym)
{
	struct hotkey* h;
	SLIST_FOREACH (h, &hk->keys, entry) {
		if (h->state == state && h->ksym == ksym) return h->hktype;
	}
	return -1;
}

int
hotkeys_add_entry (struct hotkeys* hk, int hktype, int state, KeySym ksym)
{
	struct hotkey* h;

	if (hktype < 0 || hktype > HOT_KEYS_TYPE_NUM) return -1;

	/* search if it exists already or not */
	SLIST_FOREACH (h, &hk->keys, entry) {
		if (h->state == state && h->ksym == ksym) {
			/*
			 * found!!!
			 * nothing to do.
			 */
			return 0;
		}
	}

	h = malloc (sizeof (struct hotkey));
	if (h == NULL) {
		NOMEMORY ("can't allocate memory");
		return -1;
	}

	h->state = state;
	h->ksym  = ksym;
	h->hktype = hktype;
	SLIST_INSERT_HEAD (&hk->keys, h, entry);
	return 0;
}
void
hotkeys_removeall (struct hotkeys* hk)
{
	struct hotkey*	h;

	while ((h = SLIST_FIRST (&hk->keys))) {
		SLIST_REMOVE_HEAD (&hk->keys, entry);
		free (h);
	}
}


static struct hktable
{
	const char* str;
	int   n;
} hktable[] =
{
	{"hkon",  HOT_KEYS_ON},
	{"hkonorcommit",  HOT_KEYS_ON_OR_COMMIT},
	{"hkcommit",  HOT_KEYS_COMMIT},
	{"hkbackspace",  HOT_KEYS_BACKSPACE},
	{"hkdelete",  HOT_KEYS_DELETE},
	{"hkhenkan",  HOT_KEYS_HENKAN},
	{"hkcancel",  HOT_KEYS_CANCEL},
	{"hkleft",    HOT_KEYS_LEFT},
	{"hkright",   HOT_KEYS_RIGHT},
	{"hkfirst",   HOT_KEYS_FIRST},
	{"hklast",    HOT_KEYS_LAST},
	{"hkgrow",    HOT_KEYS_GROW},
	{"hkshrink",  HOT_KEYS_SHRINK},
	{"hknextcand",  HOT_KEYS_CAND_NEXT},
	{"hkprevcand",  HOT_KEYS_CAND_PREV},

	{NULL, 0},
};
static int
search_hktable (char* c)
{
	struct hktable* s = hktable;
	while (s->str) {
		if (strcasecmp (s->str, c) == 0) {
			return s->n;
		}
		s++;
	}
	return -1;
}

static const char* defaultconf[] =
{
	"hkon         Mod1+Zenkaku_Hankaku",
	"hkon         Mod1+Escape",
	"hkon         Shift+space",
	"hkonorcommit Control+j",
	"hkcommit     Return",
	"hkbackspace  BackSpace",
	"hkbackspace  Control+h",
	"hkdelete     Control+d",
	"hkhenkan     space",
	"hkcancel     Escape",
	"hkcancel     Control+g",
	"hkleft       Left",
	"hkleft       Control+b",
	"hkright      Right",
	"hkright      Control+f",
	"hkfirst      Control+a",
	"hklast       Control+e",
	"hkgrow       Shift+Right",
	"hkgrow       Control+o",
	"hkshrink     Shift+Left",
	"hkshrink     Control+i",
	"hknextcand   Down",
	"hkprevcand   Up",
	NULL,
};
static int
parse_key (char* str, int* state, KeySym* sym)
{
	struct statestr
	{
		const char* str;
		int state;
	} statestr[] = {
		{"None", 0},
		{"Shift", ShiftMask},
		{"S", ShiftMask},
		{"Control", ControlMask},
		{"C", ControlMask},
		{"Mod1", Mod1Mask},
		{"M1", Mod1Mask},
		{"Mod2", Mod2Mask},
		{"M2", Mod2Mask},
		{"Mod3", Mod3Mask},
		{"M3", Mod3Mask},
		{"Mod4", Mod4Mask},
		{"M4", Mod4Mask},
		{"Mod5", Mod5Mask},
		{"M5", Mod5Mask},
		{NULL, 0},
	};
	char* s;

	s = str;
	*state = 0;
	*sym = NoSymbol;

	while (s) {
		char* p;
		struct statestr* ss = statestr;

		p = strchr (s, '+');
		if (p != NULL) *p++ = '\0';

		while (ss->str) {
			int ret;
			ret = strcmp (ss->str, s);
			if (ret == 0) {
				*state |= ss->state;
				break;
			}
			ss++;
		}
		if (!ss->str) {
			*sym = XStringToKeysym (s);
			if (*sym == NoSymbol) return -1;
		}

		if (!p) break;
		s = p;
	}
	if (*sym == NoSymbol) return -1;
	else                  return 0;
}
static int
setkey_line_parse (const char* buf, int* hk, int* state, KeySym* sym)
{
	int ret;
	char token[CONTROL_BUFFER_LINE_SIZE];
	char* c;
	const char* b = buf;
	c = token;

	for (;*b == ' ' || *b == '\t'; b++);
	while (*b) {
		*c++ = *b++;
		if (*b == ' ' || *b == '\t') break;
	}
	*c = '\0';

	*hk = search_hktable (token);
	if (*hk == -1) return -1;

	c = token;
	for (;*b == ' ' || *b == '\t'; b++);
	while (*b) {
		*c++ = *b++;
		if (*b == ' ' || *b == '\t') break;
	}
	*c = '\0';

	ret = parse_key (token, state, sym);
	if (ret == -1) return -1;

	return 0;
}
int
setkey_func (const char* buf)
{
	int ret;
	int hk;
	int state;
	KeySym ks;

	ret = setkey_line_parse (buf, &hk, &state, &ks);
	if (ret == 0) {
		conversion_hotkeys_add (hk, state, ks);
		return 1;
	} else {
		fprintf (stderr, "setkey: can't parse %s\n", buf);
		return 0;
	}
}
void
load_setkey_default (void)
{
	const char** c;

	for (c = defaultconf; *c != NULL; c++) {
		setkey_func (*c);
	}
}
