/*
 * aime (XIM Server) currently for Japanese
 * main routine.
 *
 * $Id: main.c,v 1.17 2002/03/26 10:46:59 taka Exp $
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include <getopt.h>

#include <X11/Xlib.h>

#include "aime.h"
#include "xim.h"
#include "control.h"
#include "cmd.h"
#include "queue.h"
#include "hotkeys.h"

/* option values */
int option_flg = 0;
int debug_mode = 0;
int disable_on_the_spot = 0;

static char* sock_name = NULL;
static char* configfile = NULL;

#define LANG "ja_JP"

static void
print_version (void)
{
	fprintf (stderr, PACKAGE " " VERSION "\n");
}
static void
print_usage (void)
{
	fprintf (stderr,
		 PACKAGE " " VERSION ", xim server\n"
		 "Usage: " PACKAGE " [options]\n"
		 "    options\n"
		 "        -h, --help            print this help\n"
		 "        -v, --version         print this help\n"
		 "        -s, --socket=NAME     specify socket name\n"
		 "        -d, --debug           debug output\n"
		 "        --disable-on-the-spot disable on the spot\n"
		);
}

static int
parse_args (int argc, char** argv)
{
	extern char* optarg;
	int c;

	struct option optlongs[] =
	{
		{"help",    no_argument,       NULL, 'h'},
		{"version", no_argument,       NULL, 'v'},
		{"debug",   no_argument,       NULL, 'd'},
		{"socket",  required_argument, NULL, 's'},
		{"conf",    required_argument, NULL, 'c'},
		{"disable-on-the-spot",  no_argument, &disable_on_the_spot, 1},
		{0, 0, 0, 0},
	};

	while ((c = getopt_long (argc, argv, "hvds:", optlongs, NULL))
	       != -1) {
		switch (c) {
		case 'v':
			print_version ();
			return -1;
			break;
		case 'd':
			debug_mode = 1;
			break;
		case 's':
			sock_name = optarg;
			break;
		case 'c':
			configfile = optarg;
			break;
		case 0:
			break;
		case 'h':
		default:
			print_usage ();
			return -1;
			break;
		}
	}

	return 0;
}

#if 0
static char*
get_homedir (void)
{
	int uid;
	char* home;
	struct passwd *pw;

	home = getenv ("HOME");
	if (home) {
		homedir = strdup (home);
		return homedir;
	}

	uid = getuid ();
	pw = getpwuid (uid);
	if (!pw){
		perror ("getpwuid");
		return NULL;
	}
	return strdup(pw->pw_dir);
}
#endif

static int
printf_internal (const char* format, va_list varg)
{
	int ret;

	ret = vfprintf (stderr, format, varg);
	fflush (stderr);
	return ret;
}
int
error_printf (const char* format, ...)
{
	va_list ap;
	int ret;

	fprintf (stderr, "%s ", PACKAGE);
	va_start (ap, format);
	ret = printf_internal (format, ap);
	va_end (ap);
	return ret;
}
int
debug_printf (const char* format, ...)
{
	va_list ap;
	int ret;

	if (!debug_mode) return 0;

	va_start (ap, format);
	ret = printf_internal (format, ap);
	va_end (ap);
	return ret;
}

#ifdef DEBUG
#undef malloc
#undef realloc
#undef strdup
#undef free
#ifndef MALLOC_COUNT
void* malloc_wrapper (int x) {return malloc (x);}
void* realloc_wrapper (void* x,int y) {return realloc (x,y);}
void* strdup_wrapper (const char* p) {return strdup (p);}
void free_wrapper (void* p) {return free (p);}
#else  /* NO_MALLOC_COUNT */
static int malloc_num;
void*
malloc_wrapper (int x)
{
	char* r;
	r = malloc (x);
	if (r) {
		malloc_num ++;
		DPRINTF ("malloc  :%d\n", malloc_num);
	}
	return r;
}
void*
realloc_wrapper (void* p, int x)
{
	int add = 0;
	char* r;

	if (p == NULL) add = 1;
	r = realloc (p, x);
	if (r && add) {
		malloc_num ++;
		DPRINTF ("realloc :%d\n", malloc_num);
	}
	return r;
}
void*
strdup_wrapper (char* p)
{
	char* r;

	r = strdup (p);
	if (r) {
		malloc_num ++;
		DPRINTF ("strdup  :%d\n", malloc_num);
	}
	return r;
}
void
free_wrapper (void* x)
{
	free (x);
	if (x) {
		malloc_num --;
		DPRINTF ("free    :%d\n", malloc_num);
	}
}
#endif /* NO_MALLOC_COUNT */
#endif /* DEBUG */

static fd_set fd_watch_read;
static fd_set fd_watch_write;
static int maxfd = -1;
struct fd_watch
{
	int fd;
	void (*func)(int,void*);
	void* data;
	int type;
	
	SLIST_ENTRY (fd_watch)	entry;
};
static SLIST_HEAD (,fd_watch) fdwatchhead = SLIST_HEAD_INITIALIZER (0);
int
add_fd_watch (int fd, int type, void (*func)(int,void*), void* data)
{
	struct fd_watch* fdw;

	fdw = malloc (sizeof (struct fd_watch));
	if (!fdw) {
		NOMEMORY ("can't allocate fd_watch");
		return -1;
	}
	memset (fdw, 0, sizeof (fdw));

	fdw->fd   = fd;
	fdw->func = func;
	fdw->data = data;
	fdw->type = type;

	SLIST_INSERT_HEAD (&fdwatchhead, fdw, entry);

	if (type & FD_WATCH_READ)  FD_SET (fd, &fd_watch_read);
	if (type & FD_WATCH_WRITE) FD_SET (fd, &fd_watch_write);

	if (maxfd < fd) maxfd = fd;
	return 0;
}
void
del_fd_watch (int fd)
{
	struct fd_watch* fdw;

	fdw = SLIST_FIRST (&fdwatchhead);
	while (fdw) {
		struct fd_watch* next = SLIST_NEXT (fdw, entry);
		if (fdw->fd == fd) {
			if (fdw->type & FD_WATCH_READ) {
				FD_CLR (fd, &fd_watch_read);
			}
			if (fdw->type & FD_WATCH_WRITE) {
				FD_CLR (fd, &fd_watch_write);
			}

			SLIST_REMOVE (&fdwatchhead, fdw, fd_watch, entry);
			free (fdw);
		}	
		fdw = next;
	}
}
static void
init_fd_watch (void)
{
	FD_ZERO (&fd_watch_read);
	FD_ZERO (&fd_watch_write);
}
static int
main_internal (void)
{
	while (1) {
		int ret;
		struct fd_watch* fdw;
		fd_set r;
		fd_set w;

		r = fd_watch_read;
		w = fd_watch_write;

	RETRY:
		ret = select (maxfd + 1, &r, &w, NULL, NULL);
		if (ret == -1) {
			if (errno == EINTR) {
				goto RETRY;
			} else {
				perror ("select");
				break;
			}
		}

		fdw = SLIST_FIRST (&fdwatchhead);
		while (fdw) {
			struct fd_watch* next = SLIST_NEXT (fdw, entry);
			if (FD_ISSET (fdw->fd, &r)) {
				fdw->func (fdw->fd, fdw->data);
			}
			fdw = next;
		}
		fdw = SLIST_FIRST (&fdwatchhead);
		while (fdw) {
			struct fd_watch* next = SLIST_NEXT (fdw, entry);
			if (FD_ISSET (fdw->fd, &w)) {
				fdw->func (fdw->fd, fdw->data);
			}
			fdw = next;
		}
	}
	return 0;
}

static int
load_conf (char* filename)
{
	char configfilename[512];
	char buffer[512];
	FILE* f;

	if (filename == NULL) {
		const char* s;
		if ((s = getenv ("HOME")) == NULL) {
			s = "/";
		}
		strcpy (configfilename, s);
		strcat (configfilename, "/");
		strcat (configfilename, ".aime");
		filename = configfilename;
	}
	
	f = fopen (filename, "r");
	if (f == NULL) return -1;

	while (fgets (buffer, sizeof (buffer), f) != NULL) {
		char* s = buffer;
		int l;

		for (;*s == ' ' || *s == '\t'; s++);

		if (s[0] == '\0') continue;
		if (s[0] == '\n') continue;
		if (s[0] == '#') continue;

		l = strlen (s);
		if (s[l - 1] == '\n') s[l - 1] = '\0';

		cmd_exec (s);
	}

	fclose (f);
	return 0;
}

int
main (int argc, char** argv)
{
	int ret;
	char lang[] = "LANG=" LANG;
	char xmod[] = "XMODIFIERS=@im=none";

	putenv (lang);
	putenv (xmod);
	setlocale (LC_ALL, LANG);

	init_fd_watch ();

	ret = parse_args (argc, argv);
	if (ret == -1) exit (1);

	ret = control_init (sock_name);
	if (ret == -1) {
		fprintf (stderr, "can't initialize control socket\n");
		return 1;
	}
	

	ret = cmd_init ();
	if (ret == -1) {
		fprintf (stderr, "can't initialize cmd table\n");
		return 1;
	}
	
	ret = xim_init ();
	if (ret == -1) {
		fprintf (stderr, "can't initialize xim server\n");
		return 1;
	}

	ret = load_conf (configfile);
	if (ret == -1) load_setkey_default ();

	main_internal ();

	return 0;
}
