/*
 * deal preedit window.
 *
 * $Id: pewindow.c,v 1.33 2002/03/26 10:46:59 taka Exp $
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>

#include "ximpacket.h"
#include "ximic.h"
#include "conversion.h"
#include "pewindow.h"
#include "ximproc.h"
#include "imconnection.h"
#include "fontset.h"
#include "conversion.h"
#include "aime.h"
#include "charcode.h"
#include "hotkeys.h"

#define ROOTSTYLE_WINDOW_NAME PACKAGE " root style"
#define OVERSPOT_WINDOW_NAME PACKAGE " over the spot"

static Atom wm_delete_window_protocol;

struct draw_rects
{
	int use;

	Window	window;
	int x;
	int y;
	int width;
	int height;
};

struct xresources
{
	int	map;

	Display*	display;
	Window		parent;		/* for re-create */
	int		ypos;
	GC		gc;
	GC		cleargc;
	unsigned long	foreground;
	unsigned long	background;
	struct fontsetentry*	fontset;
};
struct rootwindow
{
	struct xresources xr;

	Window	window;
	int	width;
	int	height;
	Pixmap	pixmap;
};
enum {
	TOP,
	MIDDLE,
	BOTTOM,
	VERT_NUM,
};
struct overspot
{
	struct xresources xr;
	int	spotx;
	int	spoty;
	int	parentwidth;
	int	parentheight;

	struct draw_rects dr[VERT_NUM];
};
struct onspot
{
};
struct pewindow
{
	int		style;
	struct pe_attribute	attr;
	struct ximic*	xic;	/* where do I belong to? */

	int cursor_x,cursor_y;

	union {
		struct rootwindow root;
		struct overspot   over;
		struct onspot     on;
	} u;
};

static void
pe_attribute_show (struct pe_attribute* attr, int changed)
{
	const char* pf;
	int mask;

	if (!debug_mode) return;

	if (changed) {
		pf = "changed";
		mask = attr->changed_mask;
	} else {
		pf = "set";
		mask = attr->set_mask;
	}

	if (mask & ATTR_MASK_FOCUS_WINDOW) {
		DPRINTF ("%s focus_window = %lx\n", pf, attr->focus_window);
	}

	if (mask & ATTR_MASK_AREA) {
		DPRINTF ("%s area.x      = %d\n", pf, attr->client_area.x);
		DPRINTF ("%s area.y      = %d\n", pf, attr->client_area.y);
		DPRINTF ("%s area.width  = %d\n", pf, attr->client_area.width);
		DPRINTF ("%s area.height = %d\n", pf, attr->client_area.height);
	}

	if (mask & ATTR_MASK_FOREGROUND) {
		DPRINTF ("%s foreground = %lx\n", pf, attr->foreground);
	}

	if (mask & ATTR_MASK_BACKGROUND) {
		DPRINTF ("%s background = %lx\n", pf, attr->background);
	}

	if (mask & ATTR_MASK_SPOT_LOCATION) {
		DPRINTF ("%s spot.x = %d\n", pf, attr->spot_location.x);
		DPRINTF ("%s spot.y = %d\n", pf, attr->spot_location.y);
	}

	if (mask & ATTR_MASK_FONTSET) {
		DPRINTF ("%s fontsetname = %s\n", pf,
			 fontset_get_fontsetname (attr->fontset));
	}

	if (mask & ATTR_MASK_STATUS_AREA) {
		DPRINTF ("%s status_area.x      = %d\n", pf,
			 attr->status_area.x);
		DPRINTF ("%s status_area.y      = %d\n", pf,
			 attr->status_area.y);
		DPRINTF ("%s status_area.width  = %d\n", pf,
			 attr->client_area.width);
		DPRINTF ("%s status_area.height = %d\n", pf,
			 attr->client_area.height);
	}
}
#define UPDATE_CURSOR(d,w,sx,sy,dx,dy)				\
	do {						       	\
		Window unused;					\
		XTranslateCoordinates ((d), (w), DefaultRootWindow ((d)), \
				       (sx), (sy), (dx), (dy), &unused);  \
	} while (0)

static int
root_over_prepare (struct pewindow* pew, int style, Display* d,
		   struct pe_attribute* attr)
{
	struct xresources* xr;

	switch (style) {
	case ROOT_WINDOW:
		xr = &pew->u.root.xr;
		break;
	case OVER_THE_SPOT:
		xr = &pew->u.over.xr;
		break;
	default:
		return -1;
	}

	if (attr->set_mask & ATTR_MASK_FOREGROUND) {
		xr->foreground = attr->foreground;
	} else {
		xr->foreground = BlackPixel (d, DefaultScreen (d));
	}
	if (attr->set_mask & ATTR_MASK_BACKGROUND) {
		xr->background = attr->background;
	} else {
		xr->background = WhitePixel (d, DefaultScreen (d));
	}
	if (attr->set_mask & ATTR_MASK_FONTSET) {
		xr->fontset = fontset_duplicate (attr->fontset);
	} else {
		xr->fontset = fontset_get_byname (d, DEFAULT_FONTSETNAME);
	}
	{
		XFontSetExtents* ext;

		ext = fontset_get_xfontsetextents (xr->fontset);
		xr->ypos = ext->max_logical_extent.y
			+ ext->max_logical_extent.height;
	}

	xr->display = d;

	switch (style) {
	case ROOT_WINDOW:
		xr->parent = DefaultRootWindow (d);
		break;
	case OVER_THE_SPOT:
		if (attr->set_mask & ATTR_MASK_FOCUS_WINDOW) {
			xr->parent = attr->focus_window;
		} else {
			return -1;
		}
		if (attr->set_mask & ATTR_MASK_SPOT_LOCATION) {
			pew->u.over.spotx = attr->spot_location.x;
			pew->u.over.spoty = attr->spot_location.y;
		} else {
			pew->u.over.spotx = 0;
			pew->u.over.spoty = 0;
		}

		break;
	default:
		return -1;
		break;
	}
	return 0;
}


static void
rootwindow_clear (struct pewindow* pew)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr = &root->xr;
	
	XFillRectangle (xr->display, root->pixmap, xr->cleargc, 0, 0,
			root->width, root->height);
	XCopyArea (xr->display, root->pixmap, root->window, xr->gc,
		   0, 0, root->width, root->height, 0, 0);
}
static void
rootwindow_create_pixmap (struct pewindow* pew)
{
	Pixmap p;
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	p = XCreatePixmap (xr->display, DefaultRootWindow (xr->display),
			   root->width, root->height,
			   DefaultDepth (xr->display,
					 DefaultScreen (xr->display)));

	xr->gc = XCreateGC (xr->display, p, 0, NULL);
	XSetForeground (xr->display, xr->gc, xr->foreground);
	XSetBackground (xr->display, xr->gc, xr->background);

	xr->cleargc = XCreateGC (xr->display, p, 0, NULL);
	XSetForeground (xr->display, xr->cleargc, xr->background);
	XSetBackground (xr->display, xr->cleargc, xr->foreground);

	pew->u.root.pixmap = p;
}
static int
rootwindow_create (struct pewindow* pew, struct pe_attribute* attr)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	XRectangle* rect;
	XFontSetExtents* ext;
	XWMHints hints;

	ext = fontset_get_xfontsetextents (xr->fontset);
	rect = &ext->max_logical_extent;
	root->width  = rect->width  * 40;
	root->height = rect->height;

	root->window = XCreateSimpleWindow (xr->display, xr->parent,
					    0, 0, root->width, root->height, 0,
					    xr->foreground, xr->background);
	XStoreName (xr->display, root->window, ROOTSTYLE_WINDOW_NAME);
	rootwindow_create_pixmap (pew);

	XSelectInput (xr->display, root->window, ExposureMask|KeyPressMask);

	hints.flags = InputHint;
	hints.input = True;
	XSetWMHints (xr->display, root->window, &hints);
	XSetWMProtocols (xr->display, root->window,
			 &wm_delete_window_protocol, 1);

	rootwindow_clear (pew);

	xr->map = 0;
	return 0;
}
static void
rootwindow_destroy (struct pewindow* pew)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	XFreeGC (xr->display, xr->gc);
	XFreeGC (xr->display, xr->cleargc);
	XFreePixmap (xr->display, root->pixmap);
	XDestroyWindow (xr->display, root->window);

	fontset_release (xr->fontset);

	XFlush (xr->display);
}
static void
rootwindow_expose (struct pewindow* pew)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	XCopyArea (xr->display, root->pixmap, root->window, xr->gc,
		   0, 0, root->width, root->height, 0, 0);
}
static int
rootwindow_update (struct pewindow* pew)
{
	struct conversion* conv = pew->xic->conv;
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;
	XFontSet xfontset;
	struct conversion_string* cstr;
	int x = 0;
	int curs_x = 0, curs_y = 0;
	int cursorset = 0;

	if (!xr->map) return 0;
	if (!conversion_show_preedit (conv)) return 0;
	
	xfontset = fontset_get_xfontset (xr->fontset);
	cstr = conversion_get_conversion_string (conv);

	while (cstr) {
		char* str = cstr->buf;
		GC fgc,bgc;
		int y = root->height - xr->ypos;
		int len;
		XRectangle inkr, logicr;

		if (!str || strlen (str) == 0) {
			cstr = TAILQ_NEXT (cstr, entry);
			continue;
		}
		len = strlen (str);

		if (cstr->stat & CONV_STAT_REVERSE) {
			fgc = xr->cleargc;
			bgc = xr->gc;
		} else {
			fgc = xr->gc;
			bgc = xr->cleargc;
		}

		if (cstr->cursor == -1) {
			/* draw at once */
			XmbDrawImageString (xr->display, root->pixmap,
					    xfontset, fgc, x, y, str, len);

		} else {
			int onecharlen;
			int sx;

			sx = x;
			/* draw string before cursor */
			XmbDrawImageString (xr->display, root->pixmap,
					    xfontset, fgc, sx, y, str,
					    cstr->cursor);
			XmbTextExtents (xfontset, str, cstr->cursor,
					&inkr, &logicr);
			sx += logicr.x + logicr.width;
			str += cstr->cursor;

			/* draw string at cursor */
			onecharlen = eucjp_next (str);
			XmbDrawImageString (xr->display, root->pixmap,
					    xfontset, bgc, sx, y, str,
					    onecharlen);
			XmbTextExtents (xfontset, str, onecharlen,
					&inkr, &logicr);
			curs_x = sx; curs_y = y; cursorset = 1;
			sx += logicr.x + logicr.width;
			str += onecharlen;


			/* draw string after cursor */
			XmbDrawImageString (xr->display, root->pixmap,
					    xfontset, fgc, sx, y, str,
					    len - onecharlen - cstr->cursor);
#if 0
			XmbTextExtents (xfontset, str,
					len - onecharlen - cstr->cursor,
					&inkr, &logicr);
#endif
		}

		str = cstr->buf;
		XmbTextExtents (xfontset, str, len, &inkr, &logicr);

		if (cstr->stat & CONV_STAT_UNDERLINE) {
			y += 1;
			XDrawLine (xr->display, root->pixmap, fgc,
				   x + 1,                           y,
				   x + logicr.x + logicr.width - 1, y);

		}
		if (cstr->stat & CONV_STAT_REVERSE) {
			curs_x = x; curs_y = y; cursorset = 1;
		}

		x += logicr.x + logicr.width;
		cstr = TAILQ_NEXT (cstr, entry);
	}
	if (cursorset) {
		UPDATE_CURSOR(xr->display, root->window, curs_x, curs_y,
			      &pew->cursor_x, &pew->cursor_y);
	}

	rootwindow_expose (pew);
	XFlush (xr->display);
	return 0;
}
static void
rootwindow_map (struct pewindow* pew)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	XMapRaised (xr->display, root->window);
	xr->map = 1;
}
static void
rootwindow_unmap (struct pewindow* pew)
{
	struct rootwindow* root = &pew->u.root;
	struct xresources* xr   = &root->xr;

	XUnmapWindow (xr->display, root->window);
	xr->map = 0;
}


static void
overspot_destroy_windows (struct pewindow* pew)
{
	struct xresources* xr   = &pew->u.over.xr;
	int i;

	for (i = 0; i < VERT_NUM; i++) {
		XDestroyWindow (xr->display, pew->u.over.dr[i].window);
	}
	XFreeGC (xr->display, xr->gc);
	XFreeGC (xr->display, xr->cleargc);
}
static void
overspot_create_windows (struct pewindow* pew)
{
	struct xresources* xr = &pew->u.over.xr;
	struct draw_rects* d;
	int i;

	for (i = 0; i < VERT_NUM; i++) {
		d = &pew->u.over.dr[i];
		d->window = XCreateSimpleWindow (xr->display, xr->parent,
						 0, 0, 1, 1, 0,
						 xr->foreground,
						 xr->background);
		d->x = d->y = 0; d->width = d->height = 1;

		XSelectInput (xr->display, d->window, ExposureMask);
	}
}
static void
overspot_clear (struct pewindow* pew)
{
	struct xresources* xr = &pew->u.over.xr;
	int i;

	for (i = 0; i < VERT_NUM; i++) {
		struct draw_rects* d = &pew->u.over.dr[i];

		XFillRectangle (xr->display, d->window, xr->cleargc,
				0, 0, d->width, d->height);
	}
}
static int
overspot_create (struct pewindow* pew, struct pe_attribute* attr)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;
	int i;

	if (attr->set_mask & ATTR_MASK_AREA) {
		over->parentwidth  = attr->client_area.width;
		over->parentheight = attr->client_area.height;
	} else {
		Window root;
		int s,gx,gy;
		unsigned int w,h,b,d;
		s = XGetGeometry (xr->display, xr->parent, &root,
				  &gx, &gy, &w, &h, &b, &d);
		if (s) {
			over->parentwidth  = w;
			over->parentheight = h;
		} else {
			return -1;
		}
	}

	xr->gc = XCreateGC (xr->display, xr->parent, 0, NULL);
	XSetForeground (xr->display, xr->gc, xr->foreground);
	XSetBackground (xr->display, xr->gc, xr->background);

	xr->cleargc = XCreateGC (xr->display, xr->parent, 0, NULL);
	XSetForeground (xr->display, xr->cleargc, xr->background);
	XSetBackground (xr->display, xr->cleargc, xr->foreground);

	for (i = 0; i < VERT_NUM; i++) {
		pew->u.over.dr[i].use = 0;
	}

	overspot_create_windows (pew);

	xr->map = 0;
	return 0;
}
static void
overspot_destroy (struct pewindow* pew)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;

	fontset_release (xr->fontset);
	XFreeGC (xr->display, xr->gc);
	XFreeGC (xr->display, xr->cleargc);
	/*
	 * no need to destroy over->dr[?].window
	 * because it is child of focus_window
	 */
	XFlush (xr->display);
}
static void
draw_rects_move_resize (Display* d, struct draw_rects* dr)
{
	XMoveResizeWindow (d, dr->window, dr->x, dr->y, dr->width, dr->height);
}
struct draw_point
{
	int x,y;
	struct
	{
		int use;
		int num;
	}rect[VERT_NUM];
	int r_index;
	struct draw_rects* dr;
	struct conversion_string* top;
};
static void
determine_cstr_pos (struct overspot* over, struct conversion_string* cstr,
		    struct draw_point* dp)
{
	char* top;
	char* str;
	XFontSet xfontset;
	struct xresources* xr = &over->xr;
	struct conversion_overspot* co;
	int pos = 0;

	top = str = cstr->buf;
	if (!str) return;

	xfontset = fontset_get_xfontset (xr->fontset);

	co = malloc (sizeof (struct conversion_overspot));
	if (co == NULL) {
		NOMEMORY ("can't allocate conversion_overspot");
		return;
	}
	co->len  = 0;
	co->curstr = NULL;
	SIMPLEQ_INSERT_TAIL (&cstr->head, co, entry);

	while (*str) {
		int len;
		XRectangle inkr, logicr;
		int charw;
		int lyh;	/* logicr.y + logicr.height */

		len = eucjp_next (str);
		if (len == 0) goto NEXT;

		XmbTextExtents (xfontset, str, len, &inkr, &logicr);
		charw = logicr.x + logicr.width;
		lyh = logicr.y + logicr.height;

		if (co->len == 0) {
			/* first co */
			co->start = str;
			co->x = dp->x;
			co->y = dp->y;
			co->w = 0;
			co->windex = dp->r_index;
			co->pos = 0;

			if (str == top)
				co->pos |= CONV_OVERSPOT_POS_START;

			if (*(str+len) == '\0')
				co->pos |= CONV_OVERSPOT_POS_END;
		}

		if (dp->x + charw <= over->parentwidth) {
			int ind = dp->r_index;

			if (dp->rect[ind].num == 0) {
				/* first rect */
				dp->rect[ind].use = 1;
				dp->rect[ind].num = 0;

				dp->dr[ind].x      = dp->x;
				dp->dr[ind].y      = dp->y + logicr.y;
				dp->dr[ind].width  = 0;
				dp->dr[ind].height = logicr.height;
			}

			dp->rect[ind].num ++;

			dp->dr[ind].width += charw;

			if (co->len == 0) {
				co->x = dp->x - dp->dr[ind].x;
				co->y = dp->y - dp->dr[ind].y;
			}

			if (pos == cstr->cursor) {
				co->curx = dp->x - dp->dr[ind].x;
				co->cury = dp->y - dp->dr[ind].y;
				co->curstr = str;
				co->curlen = len;
			}
			co->len += len;
			co->w += charw;
			if (*(str+len) == '\0')
				co->pos |= CONV_OVERSPOT_POS_END;

			dp->x += charw;
			goto NEXT;
		}

		/* fold. go to next line */
		if (dp->r_index == BOTTOM) {
			/* change bottom to middle */
			struct conversion_string* cs;
			int oldheight;

			if (dp->rect[MIDDLE].use == 0) {
				dp->dr[MIDDLE].x = 0;
				dp->dr[MIDDLE].y = dp->y + logicr.y;
				dp->dr[MIDDLE].width  = 0;
				dp->dr[MIDDLE].height = 0;
				dp->rect[MIDDLE].use = 1;
			}

			oldheight = dp->dr[MIDDLE].height;

			dp->rect[MIDDLE].use = 1;
			dp->dr[MIDDLE].width  = dp->dr[MIDDLE].width > dp->x
				? dp->dr[MIDDLE].width : dp->x;
			dp->dr[MIDDLE].height += logicr.height;
			if (dp->dr[MIDDLE].y + dp->dr[MIDDLE].height
			    > over->parentheight) {
				dp->dr[MIDDLE].height
					= over->parentheight
					- dp->dr[MIDDLE].y;
			}

			cs = dp->top;
			while (cs) {
				struct conversion_string* ncs;
				struct conversion_overspot* c;

				ncs = TAILQ_NEXT (cs, entry);
				SIMPLEQ_FOREACH (c, &cs->head, entry) {
					if (c->windex != BOTTOM) continue;

					c->windex = MIDDLE;
					c->y += oldheight;
					if (c->y + lyh
					    > dp->dr[MIDDLE].height) {
						c->y = dp->dr[MIDDLE].height
							- lyh;
					}

					dp->rect[MIDDLE].num ++;

					if (!c->curstr) continue;
					c->cury += oldheight;
					if (c->cury + lyh
					    > dp->dr[MIDDLE].height) {
						c->cury =
							dp->dr[MIDDLE].height
							- lyh;
					}
				}
				cs = ncs;
			}
		}

		if (co->len != 0) {
			co = malloc (sizeof (struct conversion_overspot));
			if (co == NULL) {
				NOMEMORY ("can't allocate conversion_overspot");
				goto NEXT;
			}
			SIMPLEQ_INSERT_TAIL (&cstr->head, co, entry);
			co->curstr = NULL;
		}

		dp->x  = 0;
		dp->dr[BOTTOM].x = 0;
		co->x = dp->x - dp->dr[BOTTOM].x;

		dp->y += logicr.height;
		if (dp->y + lyh > over->parentheight) {
			dp->y = over->parentheight - lyh;
		}
		dp->dr[BOTTOM].y = dp->y + logicr.y;
		co->y = dp->y - dp->dr[BOTTOM].y;

		dp->dr[BOTTOM].width  = charw;
		dp->dr[BOTTOM].height = logicr.height;

		dp->rect[BOTTOM].use = 1;
		dp->rect[BOTTOM].num = 1;

		dp->r_index = BOTTOM;

		co->start = str;
		co->len   = len;
		co->windex = BOTTOM;
		co->w = charw;
		co->pos = 0;

		if (pos == cstr->cursor) {
			co->curx = co->x;
			co->cury = co->y;
			co->curstr = str;
			co->curlen = len;
		}

		if (str == top)         co->pos |= CONV_OVERSPOT_POS_START;
		if (*(str+len) == '\0') co->pos |= CONV_OVERSPOT_POS_END;

		dp->x += charw;
	NEXT:
		str += len;
		pos += len;
	}
}
static int
overspot_update (struct pewindow* pew)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;
	struct conversion_string* cstr;
	int	i;
	int	is_mapped[VERT_NUM];
	struct draw_rects* dr = over->dr;
	struct draw_point dp;
	XFontSet xfontset;
	int mapone = 0;
	int curs_x = 0, curs_y = 0;
	Window curs_window = 0;

	if (!xr->map) return 0;
	if (!conversion_show_preedit (pew->xic->conv)) return 0;
	
	dp.top = cstr = conversion_get_conversion_string (pew->xic->conv);

	dp.x = over->spotx;
	dp.y = over->spoty;
	dp.r_index = 0;
	dp.dr = dr;

	for (i = 0; i < VERT_NUM; i++) {
		is_mapped[i] = dr[i].use;
		dr[i].x = dr[i].y = dr[i].width = dr[i].height = 0;
		dp.rect[i].num = dp.rect[i].use = 0;
	}

	while (cstr) {
		char* str = cstr->buf;
		int len;

		SIMPLEQ_INIT (&cstr->head);
		if (!str) goto NEXT1;
		len = strlen (str);
		if (!len) goto NEXT1;

		determine_cstr_pos (over, cstr, &dp);
		
	NEXT1:
		cstr = TAILQ_NEXT (cstr, entry);
	}

	for (i = 0; i < VERT_NUM; i++) {
		struct draw_rects* dri = &over->dr[i];
		dri->use = dp.rect[i].use;

		if (dri->use) {
			draw_rects_move_resize (xr->display, dri);
			if (!is_mapped[i]) {
				XMapRaised (xr->display, dri->window);
				mapone = 1;
				is_mapped[i] = 1;
			}
#if 0
			DPRINTF ("dr[%d] (%lx) (%d %d %d %d)\n",
				 i, dri->window, dri->x, dri->y,
				 dri->width, dri->height);
#endif
		} else {
			XUnmapWindow (xr->display, dri->window);
		}
	}

	/*
	 * if a window is mapped or raised, no need to draw
	 * because Expose Events are generated.
	 */
	if (mapone) {
		/*
		 * window stack's order is need to be top, middle, bootom
		 * from stack bottom
		 */
		if (is_mapped[TOP])
			XMapRaised (xr->display, over->dr[TOP].window);
		if (is_mapped[MIDDLE])
			XMapRaised (xr->display, over->dr[MIDDLE].window);
		if (is_mapped[BOTTOM])
			XMapRaised (xr->display, over->dr[BOTTOM].window);

		goto FREE;
	}

	xfontset = fontset_get_xfontset (xr->fontset);
	cstr = dp.top;
	while (cstr) {
		char* str = cstr->buf;
		struct conversion_overspot* co;
		GC fgc,bgc;
		int len;

		if (!str) goto NEXT2;
		len = strlen (str);
		if (!len) goto NEXT2;

		if (cstr->stat & CONV_STAT_REVERSE) {
			fgc = xr->cleargc;
			bgc = xr->gc;
		} else {
			fgc = xr->gc;
			bgc = xr->cleargc;
		}

		SIMPLEQ_FOREACH (co, &cstr->head, entry) {
			XmbDrawImageString (xr->display,
					    over->dr[co->windex].window,
					    xfontset, fgc,
					    co->x, co->y, co->start, co->len);

			if (co->curstr) {
				XmbDrawImageString (
					xr->display,
					over->dr[co->windex].window,
					xfontset, bgc,
					co->curx, co->cury, co->curstr,
					co->curlen);
#if 0
				DPRINTF ("*** cursor (x,y)=(%d,%d) %s(%d)\n",
					 co->curx, co->cury, co->curstr,
					 co->curlen);
#endif
			}
		
			if (cstr->stat & CONV_STAT_UNDERLINE) {
				int sx,ex,y;

				sx = co->x;
				ex = co->x + co->w;
				y  = co->y + xr->ypos - 1;
				if (co->pos & CONV_OVERSPOT_POS_START) sx += 2;
				if (co->pos & CONV_OVERSPOT_POS_END)   ex -= 2;

				if (ex - sx > 0) {
					XDrawLine (xr->display,
						   over->dr[co->windex].window,
						   fgc, sx, y, ex, y);
				}
			}
			if (cstr->stat & CONV_STAT_REVERSE) {
				/* update cursor_{x,y} for candidate window */
				curs_window = over->dr[co->windex].window;
				curs_x = co->x; curs_y = co->y;
			}
#if 0
			DPRINTF (" draw %s(%d) at (%lx) (%d,%d) w=%d %d stat=%x\n",
				 co->start, co->len,
				 over->dr[co->windex].window,
				 co->x, co->y, co->w, co->pos, cstr->stat);
#endif
		}

	NEXT2:
		cstr = TAILQ_NEXT (cstr, entry);
		continue;
	}

	if (curs_window) {
		UPDATE_CURSOR(xr->display, curs_window, curs_x, curs_y,
			      &pew->cursor_x, &pew->cursor_y);
	}

 FREE:
	/* free */
	cstr = dp.top;
	while (cstr) {
		struct conversion_string* next = TAILQ_NEXT (cstr, entry);
		struct conversion_overspot* co;

		co = SIMPLEQ_FIRST (&cstr->head);
		while (co) {
			struct conversion_overspot* conext;
			conext = SIMPLEQ_NEXT (co, entry);
			SIMPLEQ_REMOVE_HEAD (&cstr->head, co, entry);
			free (co);
			co = conext;
		}
		cstr = next;
	}

	XFlush (xr->display);
	return 0;
}
static void
overspot_expose (struct pewindow* pew)
{
	overspot_update (pew);
}
static int
overspot_change_attributes (struct pewindow* pew)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;
	struct pe_attribute* attr = &pew->attr;
	int update = 0;

	if (attr->changed_mask & ATTR_MASK_FOCUS_WINDOW) {
		int map_save;
		int ret;

		/* focus is changed! */
		map_save = xr->map;
		overspot_destroy_windows (pew);
		xr->parent = attr->focus_window;
		ret = overspot_create (pew, attr);
		if (ret == -1) {
			fontset_release (xr->fontset);
			free (pew);
			return -1;
		}
		xr->map = map_save;
		update = 1;
	}

	if (attr->changed_mask & ATTR_MASK_FOREGROUND) {
		xr->foreground = attr->foreground;
		XSetForeground (xr->display, xr->gc, xr->foreground);
		XSetBackground (xr->display, xr->cleargc, xr->foreground);
		update = 1;
	}

	if (attr->changed_mask & ATTR_MASK_BACKGROUND) {
		xr->background = attr->background;
		XSetBackground (xr->display, xr->gc, xr->background);
		XSetForeground (xr->display, xr->cleargc, xr->background);
		update = 1;
	}

	if (attr->changed_mask & ATTR_MASK_SPOT_LOCATION) {
		over->spotx = attr->spot_location.x;
		over->spoty = attr->spot_location.y;
		update = 1;
	}

	if (attr->changed_mask & ATTR_MASK_FONTSET) {
		if (xr->fontset != attr->fontset) {
			fontset_release (xr->fontset);
			xr->fontset = fontset_duplicate (attr->fontset);
		}
		update = 1;
	}

	if (update && xr->map) overspot_update (pew);
	return 0;
}
static void
overspot_map (struct pewindow* pew)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;

	xr->map = 1;
	overspot_update (pew);
}
static void
overspot_unmap (struct pewindow* pew)
{
	struct overspot* over = &pew->u.over;
	struct xresources* xr = &over->xr;
	int i;

	xr->map = 0;

	for (i = 0; i < VERT_NUM; i++) {
		over->dr[i].use = 0;
		XUnmapWindow (xr->display, over->dr[i].window);
	}
}
static void
overspot_focus_changed (struct pewindow* pew, int v)
{
	if (v) overspot_map (pew);
	else   overspot_unmap (pew);
}


static int
onspot_create (struct pewindow* pew, struct pe_attribute* attr)
{
	return ximp_preedit_start (pew->xic->conv);
}
static void
onspot_destroy (struct pewindow* pew)
{
	ximp_preedit_stop (pew->xic->conv);
}
static void
onspot_clear (struct pewindow *pew)
{
	ximp_preedit_draw (pew->xic->conv, 0);
}
static int
onspot_update (struct pewindow *pew)
{
	return ximp_preedit_draw (pew->xic->conv, 0);
}
static void
onspot_commit (struct pewindow *pew)
{
	ximp_preedit_draw (pew->xic->conv, 1);
}

/*
 * create function is not included because there are many variables to create.
 */
struct function_table
{
	int (*prepare) (struct pewindow*, int, Display*, struct pe_attribute*);
	int (*create) (struct pewindow*, struct pe_attribute*);
	void (*destroy) (struct pewindow*);
	void (*clear) (struct pewindow*);
	void (*expose) (struct pewindow*);
	int (*update) (struct pewindow*);
	void (*map) (struct pewindow*);
	void (*unmap) (struct pewindow*);
	int (*change_attributes) (struct pewindow*);
	void (*focus_changed) (struct pewindow*, int);
	void (*commit) (struct pewindow*);
}style_func_table[INPUT_TYPE_NUM] =
{
	/* INVALID */
	{},

	/* ROOT_WINDOW */
	{root_over_prepare, rootwindow_create, rootwindow_destroy,
	 rootwindow_clear, rootwindow_expose, rootwindow_update,
	 rootwindow_map, rootwindow_unmap, NULL, NULL, NULL},

	/* OVER_THE_SPOT */
	{root_over_prepare, overspot_create, overspot_destroy,
	 overspot_clear, overspot_expose, overspot_update,
	 overspot_map, overspot_unmap, overspot_change_attributes,
	 overspot_focus_changed, NULL},

	/* ON_THE_SPOT */
	{NULL, onspot_create, onspot_destroy,
	 onspot_clear, NULL, onspot_update,
	 NULL, NULL, NULL,
	 NULL, onspot_commit},

	/* OFF_THE_SPOT */
	{},
};
#define CHECK_STYLE(p,s) do {					\
	if ((p->style) < 0 || (p->style) > INPUT_TYPE_NUM) {	\
		s;						\
	}							\
} while (0)
void
pewindow_clear (struct pewindow* pew)
{
	CHECK_STYLE(pew,return);
	if (style_func_table[pew->style].clear) {
		style_func_table[pew->style].clear (pew);
	}
}
struct pewindow* 
pewindow_create (struct ximic* xic, Display* d, int style)
{
	int ret;
	struct pewindow* pewin;
	struct pe_attribute attr;

	ximic_make_peattribute (xic, &attr);
	pe_attribute_show (&attr, 0);

	pewin = malloc (sizeof (struct pewindow));
	if (pewin == NULL) {
		NOMEMORY ("can't allocate preedit window");
		return NULL;
	}
	memset (pewin, 0, sizeof (struct pewindow));

	pewin->xic = xic;
	pewin->style = style;

	CHECK_STYLE(pewin,return NULL);

	if (style_func_table[style].prepare) {
		ret = style_func_table[style].prepare (pewin, style, d, &attr);
		if (ret == -1) {
			free (pewin);
			return NULL;
		}
	}
	if (style_func_table[style].create) {
		ret = style_func_table[style].create (pewin, &attr);
		if (ret == -1) {
			pewindow_clear (pewin);
			free (pewin);
			return NULL;
		}
	}
	XFlush (d);
	return pewin;
}
void
pewindow_destroy (struct pewindow* pew)
{
	if (!pew) return;

	CHECK_STYLE (pew, return);

	if (style_func_table[pew->style].destroy) {
		style_func_table[pew->style].destroy (pew);
	}

	free (pew);
}
void
pewindow_expose (struct pewindow* pew)
{
	CHECK_STYLE (pew, return);

	if (style_func_table[pew->style].expose) {
		style_func_table[pew->style].expose (pew);
	}
}
int
pewindow_update (struct pewindow* pew)
{
	CHECK_STYLE (pew, return -1);

	if (style_func_table[pew->style].update) {
		return style_func_table[pew->style].update (pew);
	}
	return 0;
}
void
pewindow_map (struct pewindow* pew)
{
	CHECK_STYLE (pew, return);

	if (style_func_table[pew->style].map) {
		style_func_table[pew->style].map (pew);
	}
}
void
pewindow_unmap (struct pewindow* pew)
{
	CHECK_STYLE (pew, return);

	if (style_func_table[pew->style].unmap) {
		style_func_table[pew->style].unmap (pew);
	}
}
int
pewindow_change_attribute (struct pewindow* pew)
{
	CHECK_STYLE (pew, return -1);

	if (style_func_table[pew->style].change_attributes) {
		pe_attribute_show (&pew->attr, 1);
		return style_func_table[pew->style].change_attributes (pew);
	}
	return 0;
}
void
pewindow_focus_changed (struct pewindow* pew, int val)
{
	CHECK_STYLE (pew, return);
	if (style_func_table[pew->style].focus_changed) {
		return style_func_table[pew->style].focus_changed (pew, val);
	}
	return;
}
void
pewindow_commit (struct pewindow* pew)
{
	CHECK_STYLE (pew, return);
	if (style_func_table[pew->style].commit) {
		return style_func_table[pew->style].commit (pew);
	}

	/* update pewindow */
	pewindow_clear (pew);
	pewindow_update (pew);
	return;
}

int
pewindow_proc_xevent (struct pewindow* pew, XEvent* e)
{
	Window w = e->xany.window;

	switch (pew->style) {
	case ROOT_WINDOW:
		if (w != pew->u.root.window) return 0;
		break;
	case OVER_THE_SPOT:
		if (w == pew->u.over.dr[TOP].window)         break;
		else if (w == pew->u.over.dr[MIDDLE].window) break;
		else if (w == pew->u.over.dr[BOTTOM].window) break;
		return 0;
		break;
	default:
		return 0;
		break;
	}

	switch (e->type) {
	case Expose:
		pewindow_expose (pew);
		break;
	case KeyPress:
	{
		int ret;
		ret = invoke_key_press (pew->xic->conv, e, 0, NULL, 0);
		if (ret == 0) {
			imc_send_packets (pew->xic->imc);
		}
		break;
	}
	case ClientMessage:
		if (e->xclient.data.l[0] == wm_delete_window_protocol) {
			conversion_emulate_hotkey (pew->xic->conv,
						   HOT_KEYS_ASCII);
		}
	default:
		break;
	}
	return 1;
}
struct pe_attribute*
pewindow_get_peattribute (struct pewindow* pew)
{
	return &pew->attr;
}
void
pewindow_initialize_module (Display* d)
{
	wm_delete_window_protocol = XInternAtom (d, "WM_DELETE_WINDOW", True);
}
void
pewindow_get_cursor (struct pewindow* pew, int* x, int*y)
{
	*x = pew->cursor_x;
	*y = pew->cursor_y;
}
