/*
 * header file of pre edit window.
 *
 * $Id: pewindow.h,v 1.12 2002/02/25 21:48:14 taka Exp $
 */
#ifndef PEWINDOW_H_INCLUDED
#define PEWINDOW_H_INCLUDED
#include <X11/Intrinsic.h>

/* pe means PreEdit */
struct pe_attribute
{
	unsigned long set_mask;
	unsigned long changed_mask;
	
	Window	focus_window;
	XRectangle client_area;
	Pixel foreground;
	Pixel background;
	struct fontsetentry* fontset;
	XPoint spot_location;
	XRectangle status_area;
};

struct pewindow;
struct ximic;
struct pewindow* 
pewindow_create (struct ximic* xic, Display* d, int type);
void
pewindow_destroy (struct pewindow* pew);
void
pewindow_expose (struct pewindow* pew);
int
pewindow_update (struct pewindow* pew);
void
pewindow_clear (struct pewindow* pew);
void
pewindow_map (struct pewindow* pew);
void
pewindow_unmap (struct pewindow* pew);
int
pewindow_proc_xevent (struct pewindow* pew, XEvent* e);
int
pewindow_change_attribute (struct pewindow* pew);
void
pewindow_focus_changed (struct pewindow* pew, int val);
void
pewindow_commit (struct pewindow* pew);

struct pe_attribute*
pewindow_get_peattribute (struct pewindow* pew);
void
pewindow_initialize_module (Display* d);
void
pewindow_get_cursor (struct pewindow* pew, int* x, int*y);

#endif /* PEWINDOW_H_INCLUDED */
