/*
 * main routine.
 *
 * $Id: main.c,v 1.2 2002/03/26 10:47:00 taka Exp $
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#ifndef SUN_LEN
#define SUN_LEN(s) \
	(sizeof (*(s)) - sizeof ((s)->sun_path) + strlen ((s))->sun_path)
#endif

#include <gtk/gtk.h>

#include "main.h"
#include "toolbox.h"
#include "cmd.h"
#include "bufsize.h"

int option_flg;

static const char* sockname = CONTROL_DEFAULT_SOCKET_NAME;

static int aimefd;

static void
print_usage (void)
{
	fprintf (stderr, "aime_gtkui [option]\n");
	fprintf (stderr, "  option\n");
	fprintf (stderr, "    -h                   print this help\n");
	fprintf (stderr, "    -v                   print version\n");
	fprintf (stderr, "    -s socketname        socket name of %s\n",
		 PACKAGE);
#ifdef USE_GNOME_APPLET
	fprintf (stderr, "    --no-gnome-applet    print version\n");
#endif /* USE_GNOME_APPLET */
}
static int
parse_option (int argc, char** argv)
{
	int i;
	option_flg |= OPTION_GNOME_APPLET;

	for (i = 1; i < argc; i++) {
		int j = 0;

		if (argv[i][j++] != '-') continue;

		switch (argv[i][j]) {
		case '-':
#ifdef USE_GNOME_APPLET
			if (strcmp (argv[i] + j, "-no-gnome-applet") == 0) {
				option_flg &= ~OPTION_GNOME_APPLET;
			}
#endif /* USE_GNOME_APPLET */
			break;
		case 'h':
			print_usage ();
			return -1;
			break;
		case 'v':
			fprintf (stderr, "aime_gtkui " VERSION "\n");
			return -1;
			break;
		case 's':
			i++;
			sockname = argv[i];
			if (sockname == NULL) {
				fprintf (stderr, "need one argument\n");
				return -1;
			}
			break;
		case 0:
			break;
		default:
			fprintf (stderr, "unknown option %c\n", argv[i][j]);
			return -1;
		}
	}
	return 0;
}


static void
encode (char* from, char* to)
{
	while (*from) {
		switch (*from) {
		case '\n':
			*to++ = '\\';
			*to++ = 'n';
			from ++;
			break;
		case '\\':
			*to++ = '\\';
			*to++ = *from++;
			break;
		default:
			*to++ = *from++;
			break;
		}
	}
	*to = *from;
}
static void
decode (char* from, char* to)
{
	while (*from) {
		if (*from == '\\') {
			switch (*from++) {
			case 'n':
				*to++ = '\n';
				break;
			case '\\':
			default:
				*to++ = *from++;
				break;
			}
		} else {
			*to++ = *from++;
		}
	}
	*to = *from;
}
static int
connect_aime (const char* name)
{
	int fd;
	int ret;
	struct sockaddr_un s;

	strncpy (s.sun_path, name, sizeof (s.sun_path));
	s.sun_path[sizeof (s.sun_path) - 1] = '\0';
	s.sun_family = AF_UNIX;

	fd = socket (PF_UNIX, SOCK_STREAM, 0);
	if (fd == -1) {
		perror ("socket");
		return -1;
	}
	ret = connect (fd, (struct sockaddr*)&s, SUN_LEN (&s));
	if (ret == -1) {
		perror ("connect");
		close (fd);
		return -1;
	}

	return fd;
}

static char buffer[256];
static char en_de_buffer[256*2 + 2];
static int bufferlen;

static void
socket_read (gpointer data, gint fd, GdkInputCondition cond)
{
	int ret;
	char line[256 + 1];
	char* str;
	char* l;

	ret = read (fd, buffer + bufferlen, sizeof (buffer) - bufferlen);
	if (ret == -1) {
		perror ("read");
		fprintf (stderr, "aime is dead\n");
		close (fd);
		gtk_main_quit ();
		return;
	} else if (ret == 0) {
		fprintf (stderr, "aime is dead\n");
		close (fd);
		gtk_main_quit ();
		return;
	}
	bufferlen += ret;

	memcpy (line, buffer, sizeof (buffer));
	line[bufferlen] = '\0';

	l = line;
	while ((str = index (l, '\n')) != NULL) {
		int len;

		*str = '\0';
		len = str - l + 1;
		memmove (buffer, buffer + len, bufferlen - len);
		bufferlen -= len;

		decode (l, en_de_buffer);
		cmd_exec (en_de_buffer);

		l = str + 1;
	}

	if (bufferlen == sizeof (buffer)) {
		fprintf (stderr, "can't find newline\n");
		bufferlen = 0;
	}
}

void
write_to_aime (char* cmd)
{
	int len;
	int ret;

	len = strlen (cmd);
	if (len > sizeof (buffer)) {
		fprintf (stderr, "can't send so long message\n");
		return;
	};

	encode (cmd, en_de_buffer);
	strcat (en_de_buffer, "\n");
	cmd = en_de_buffer;

	len = strlen (cmd);
	ret = write (aimefd, cmd, len);
	if (ret == -1 || ret != len) {
		fprintf (stderr, "write returns %d.(assume %d)\n", ret, len);
		close (aimefd);
		gtk_main_quit ();
	}
}

#define GDK_INPUT_FUNCTION(a) ((void (*)(gpointer, gint, GdkInputCondition))a)

int
main (int argc, char** argv)
{
	int ret;

	ret = parse_option (argc, argv);
	if (ret == -1) exit (1);

	ret = cmd_init ();
	if (ret == -1) {
		fprintf (stderr, "can't initialize cmd tree\n");
		exit (1);
	}

	aimefd = connect_aime (sockname);
	if (aimefd == -1) exit (1);

	gdk_input_add (aimefd, GDK_INPUT_READ, socket_read, NULL);

	toolbox_init (&argc, &argv);

	toolbox_main ();

	return 0;
}
