/*
 * toolbox with gtk (gnome applet)
 *
 * $Id: toolbox.c,v 1.2 2002/03/26 10:47:00 taka Exp $
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#include <X11/Xlib.h>

#include <gtk/gtk.h>

#ifdef USE_GNOME_APPLET
#include <applet-widget.h>
#endif

#include "main.h"
#include "toolbox.h"

#include "a.xpm"
#include "a4a2.xpm"
#include "a5a2.xpm"
#include "a3c1.xpm"
#include "kana.xpm"

static GtkWidget* topwindow;
static GtkWidget* imbutton;

struct immode
{
	GtkWidget*	pixmap;
	char**	data;
	const char*	label;		/* EUC-JP */
	const char*	cmdname;		/* INPUT_MODE_XXXX */
};
static struct immode immodes[] =
{
	{NULL, a_xpm,    "Ⱦѱѿ", "ascii"},
	{NULL, a4a2_xpm, "Ҥ餬", "hira"},
	{NULL, a5a2_xpm, "", "kata"},
	{NULL, a3c1_xpm, "ѱѿ", "zen_ascii"},
	{NULL, kana_xpm, "̾", "kana"},
	{NULL, NULL, NULL, NULL},
};
static const char* oldmode;


static GtkWidget*
simple_pixmap (GtkWidget* parent, char** xpm_data)
{
	GtkStyle*  style;
	GtkWidget* pixmapwid;
	GdkPixmap* pixmap;
	GdkBitmap* mask;

	style = gtk_widget_get_style (parent);
	pixmap = gdk_pixmap_create_from_xpm_d (parent->window, &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar**)xpm_data);
	pixmapwid = gtk_pixmap_new (pixmap, mask);
	gtk_widget_show (pixmapwid);
	return pixmapwid;
}

static void
im_menu_change_callback (gpointer cmd)
{
	struct immode* p;

	for (p = immodes; p->data != NULL; p++) {
		if (p->cmdname == oldmode) {
			gtk_container_remove (GTK_CONTAINER (imbutton),
					      p->pixmap);
			break;
		}
	}
	for (p = immodes; p->data != NULL; p++) {
		if (strcmp (p->cmdname, cmd) == 0) {
			gtk_container_add (GTK_CONTAINER (imbutton),
					   p->pixmap);
			oldmode = p->cmdname;
			break;
		}
	}
}

static void
im_menu_add (GtkWidget* menu, const char* label, gpointer mode)
{
	GtkWidget* menuitem;

	menuitem = gtk_menu_item_new_with_label (label);
	gtk_menu_append (GTK_MENU (menu), menuitem);
#if 0
	gtk_signal_connect_object (GTK_OBJECT (menuitem), "activate",
				   GTK_SIGNAL_FUNC (im_menu_change_callback),
				   mode);
#endif
	gtk_widget_show (menuitem);
}

static gint
im_button_press (GtkWidget* widget, GdkEvent* event)
{
#if 0
	if (event->type == GDK_BUTTON_PRESS) {
		GdkEventButton* bevent = (GdkEventButton*) event;
		gtk_menu_popup (GTK_MENU (widget), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);
		/* we have handled this event. */
		return TRUE;
	}
#endif
	/* we have not handled this event. pass it on. */
	return FALSE;
}

#if 0	
static gint
code_button_press (GtkWidget* widget, GdkEvent* event, gpointer data)
{
	fprintf (stderr, "code button pressed.\n");
	return TRUE;
}
#endif

int
toolbox_init (int* argc, char*** argv)
{
	GtkWidget* hbox;

	gtk_set_locale ();
	
#ifdef USE_GNOME_APPLET
	if (option_flg & OPTION_GNOME_APPLET) {
		applet_widget_init (PACKAGE "_toolbox", VERSION,
				    *argc, *argv, NULL, 0, NULL);
		topwindow = applet_widget_new (PACKAGE "_toolbox");
	} else {
#endif
		gtk_init (argc, argv);
		topwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (topwindow), PACKAGE);
#ifdef USE_GNOME_APPLET
	}
#endif
	gtk_widget_realize (topwindow);


	/* create top level container */
	hbox = gtk_hbox_new (FALSE, 0);

#ifdef USE_GNOME_APPLET
	if (option_flg & OPTION_GNOME_APPLET) {
		applet_widget_add (APPLET_WIDGET (topwindow), hbox);
	} else {
#endif
		gtk_container_add (GTK_CONTAINER (topwindow), hbox);
#ifdef USE_GNOME_APPLET
	}
#endif

	/* create input mode(im) button */
	{
		GtkWidget* menu;
		GtkWidget* initbox = NULL;
		struct immode* p;

		menu = gtk_menu_new ();
		for (p = immodes; p->label != NULL; p++) {
			/* create menu for popup */
			im_menu_add (menu, p->label, (gpointer)p->cmdname);

			/* create pixmaps for im mode indicator */
			p->pixmap = simple_pixmap (topwindow, p->data);

			/*
			 * increment reference count
			 * for future gtk_container_remove
			 */
			gtk_widget_ref (p->pixmap);

			if (p == immodes) {
				oldmode = p->cmdname;
				initbox = p->pixmap;
			}
		}

		imbutton = gtk_button_new ();
		gtk_signal_connect_object (GTK_OBJECT (imbutton), "event",
					   GTK_SIGNAL_FUNC (im_button_press),
					   GTK_OBJECT (menu));
		gtk_box_pack_start (GTK_BOX (hbox), imbutton, FALSE, FALSE, 2);
		gtk_container_add (GTK_CONTAINER (imbutton), initbox);
		gtk_widget_show (imbutton);
	}

#if 0	
	/* create code table button */
	{
		GtkWidget* button;
		GtkWidget* pixmap;

		button = gtk_button_new ();
		pixmap = simple_pixmap (topwindow, code_xpm);
		gtk_container_add (GTK_CONTAINER (button), pixmap);
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
				    GTK_SIGNAL_FUNC (code_button_press), NULL);
		gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 2);
		gtk_widget_show (button);
	}
#endif

	gtk_widget_show (hbox);
	gtk_widget_show (topwindow);

	return 0;
}

void
toolbox_main (void)
{
#ifdef USE_GNOME_APPLET
	if (option_flg & OPTION_GNOME_APPLET) {
		applet_widget_gtk_main ();
	} else {
#endif
		gtk_main ();
#ifdef USE_GNOME_APPLET
	}
#endif
}

void
toolbox_mode_change (char* buf)
{
	gtk_widget_set_sensitive (imbutton, 1);
	im_menu_change_callback (buf);
}
void
toolbox_on (char* buf)
{
	gtk_widget_set_sensitive (imbutton, 1);
}
void
toolbox_off (char* buf)
{
	gtk_widget_set_sensitive (imbutton, 0);
}
