/*
 * text user interface
 *
 * $Id: main.c,v 1.5 2002/03/26 10:47:00 taka Exp $
 */
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "bufsize.h"
#include "dencode.h"

static int
connect_aime (const char* name)
{
	int fd;
	int ret;
	struct sockaddr_un s;

	if (!name) name = CONTROL_DEFAULT_SOCKET_NAME;

	strncpy (s.sun_path, name, sizeof (s.sun_path));
	s.sun_path[sizeof (s.sun_path) - 1] = '\0';
	s.sun_family = AF_UNIX;

	fd = socket (PF_UNIX, SOCK_STREAM, 0);
	if (fd == -1) {
		perror ("socket");
		return -1;
	}
	ret = connect (fd, (struct sockaddr*)&s, SUN_LEN (&s));
	if (ret == -1) {
		perror ("connect");
		close (fd);
		return -1;
	}

	return fd;
}

static char buffer[CONTROL_BUFFER_LINE_SIZE];
static char en_de_buffer[CONTROL_BUFFER_LINE_SIZE * 2 + 2];
int
main (int argc, char** argv)
{
	char* sockname = NULL;
	extern char* optarg;
	int c;
	int fd;

	while ((c = getopt (argc, argv, "s:")) != -1) {
		switch (c) {
		case 's':
			sockname = optarg;
			break;
		default:
			break;
		}
	}

	fd = connect_aime (sockname);
	if (fd == -1) {
		fprintf (stderr, "can't connect to aime\n");
		return -1;
	}

	while (1) {
		int ret;
		int maxfd;
		fd_set r;

		FD_ZERO (&r);
		FD_SET (fd, &r);
		FD_SET (0, &r);
		maxfd = fd;

	RETRY:
		ret = select (maxfd + 1, &r, NULL, NULL, NULL);
		if (ret == -1) {
			if (errno == EINTR) goto RETRY;
			perror ("select");
			break;
		}

		if (FD_ISSET (0, &r)) {
			ret = read (0, buffer, sizeof (buffer));
			if (ret == -1) {
				perror ("read");
				fprintf (stderr, "stdin is closed\n");
				break;
			} else if (ret == 0) {
				fprintf (stderr, "stdin is closed\n");
				break;
			}
			/* remove newline */
			buffer[ret - 1] = '\0';

			encode (buffer, en_de_buffer);
			ret = write (fd, en_de_buffer, strlen (en_de_buffer));
			if (ret == -1) {
				perror ("write");
				break;
			}
		}
		if (FD_ISSET (fd, &r)) {
			ret = read (fd, buffer, sizeof (buffer));
			if (ret == -1) {
				perror ("read");
				fprintf (stderr, "aime is dead\n");
				break;
			} else if (ret == 0) {
				fprintf (stderr, "aime is dead\n");
				break;
			}
			/* remove newline */
			buffer[ret - 1] = '\0';

			decode (buffer, en_de_buffer);
			fprintf (stdout, "%s\n", en_de_buffer);
			fflush (stdout);
		}
	}
	return 0;
}
