/* aimetrans.h -- transport facilities for AIME user interfaces.
   Copyright (C) 2002  TAKAI Kousuke <tak@kmc.gr.jp>.  */

/* $Id: aimetrans.h,v 1.2 2002/03/26 10:47:00 taka Exp $ */

#ifndef AIMETRANS_H
#define AIMETRANS_H 1

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_STDBOOL_H
# include <stdbool.h>
#endif

struct aimetrans_ops;

enum aimetrans_mode
  {
    AMODE_ASCII,
    AMODE_HIRA,
    AMODE_KATA,
    AMODE_ZEN_ASCII,
    AMODE_KANA,
  };

struct aimetrans_cbs
  {
    int (*onoff) (void *);
    int (*mode) (void *, enum aimetrans_mode);
    int (*candidate_start) (void *, int, int);
    int (*candidate) (void *, int, const char *);
    int (*candidate_coord) (void *, int, int);
    int (*candidate_stop) (void *);
    int (*candidate_select) (void *, int);
  };

struct aimetrans
  {
    int fd;
    void *cb_data;
    struct aimetrans_ops const *ops;
    char *rbuf;
    size_t rbuf_size;
    size_t rbuf_cur;
    struct aimetrans_cbs const *cbs;
  };

/* Establish connection between AIME server using specified transport TYPE,
   with transport-type dependent PEER.  */
extern struct aimetrans *aimetrans_open (const char *type, void *peer);

/* Shutdown TRANSPORT and release associated resources.  */
extern void aimetrans_close (struct aimetrans *transport);

/* Return TRUE if given TRANSPORT uses TRANSPORT->fd for input.  */
extern bool aimetrans_fd_input_needed (const struct aimetrans *transport);

/* Process input to TRANSPORT->fd and call aimetrans_cb_* function if
   appropriate.  (Typical use of this function is calling it from
   select(2) or poll(2) dispatcher.)  */
extern int aimetrans_process_fd_input (struct aimetrans *transport);

/* Callback functions.  */
extern int aimetrans_cb_onoff (struct aimetrans *, bool);
extern int aimetrans_cb_mode (struct aimetrans *, enum aimetrans_mode);
extern int aimetrans_cb_candidate_start (struct aimetrans *, int, int);
extern int aimetrans_cb_candidate (struct aimetrans *, int, int, const char *);
extern int aimetrans_cb_candidate_coord (struct aimetrans *, int, int, int);
extern int aimetrans_cb_candidate_stop (struct aimetrans *, int);
extern int aimetrans_cb_candidate_select (struct aimetrans *, int, int);

#endif
