/* candidate.c -- candidate list handling
   Copyright (C) 2002  TAKAI Kousuke <tak@kmc.gr.jp>.  */

/* $Id: candidate.c,v 1.2 2002/03/26 10:47:00 taka Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "aimetrans.h"
#include "ui-xaw.h"

#include "candlist.h"

int
aimetrans_cb_candidate_start (struct aimetrans *const ax, int id, int n)
{
  int i;
  struct xawui_cb_data *const data = ax->cb_data;

  printf ("AIME CANDIDATE START %d\n", n);

  data->candidates = xmalloc (sizeof (char *) * n);
  for (i = 0; i < n; i++)
    data->candidates[i] = NULL;
  data->cand_alloc = n;
  data->ncandidates = 0;

  return 0;
}

int
aimetrans_cb_candidate_stop (struct aimetrans *const ax, int id)
{
  struct xawui_cb_data *const data = ax->cb_data;

  printf ("AIME CANDIDATE STOP\n");

  free (data->candidates);

  XtUnrealizeWidget (data->candidate_shell);
  return 0;
}

int
aimetrans_cb_candidate (struct aimetrans *const ax, int id, int n,
			const char *cand)
{
  struct xawui_cb_data *const data = ax->cb_data;

  //printf ("AIME CANDIDATE #%d \"%s\"\n", n, cand);

  if (n >= data->cand_alloc)
    {
      size_t i;
      size_t newalloc = (n + 8) & -8;
#if 0
      String param[1];
      /* issue a warning message */
#endif

      data->candidates
	= xrealloc (data->candidates, sizeof (char *) * newalloc);
      for (i = data->cand_alloc; i < newalloc; i++)
	data->candidates[i] = NULL;
      data->cand_alloc = newalloc;
    }
  data->candidates[n] = xstrdup (cand);
  if (n >= data->ncandidates)
    data->ncandidates = n + 1;

  return 0;
}

int
aimetrans_cb_candidate_select (struct aimetrans *const ax, int id, int n)
{
  struct xawui_cb_data *const data = ax->cb_data;

  printf ("AIME CANDIDATE SELECT %d\n", n);
  candidate_list_set_highlight (data->candidate_shell, n);

  return 0;
}

int
aimetrans_cb_candidate_coord (struct aimetrans *const ax, int id, int x, int y)
{
  struct xawui_cb_data *const data = ax->cb_data;

  if (!data->ncandidates)
    return 0;

  XtVaSetValues (data->candidate_shell,
		 XtNx, x, XtNy, y,
		 NULL);
  candidate_list_set_strings (data->candidate_shell,
			      data->candidates, data->ncandidates);
  XtRealizeWidget (data->candidate_shell);
  XtMapWidget (data->candidate_shell);
  return 0;
}
