/* candlist.c -- CandidateList widget
   Copyright (C) 2002  TAKAI Kousuke <tak@kmc.gr.jp>.  */
/* $Id: candlist.c,v 1.2 2002/03/26 10:47:00 taka Exp $ */
   
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>

#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>

#define SUPERCLASS	(&transientShellClassRec)

struct CandidateListPart
  {
    Widget vport_w;
    Widget list_w;
  };

struct CandidateList
  {
    TransientShellRec shell;
    struct CandidateListPart candidate_list;
  };

struct CandidateListClass
  {
    TransientShellClassRec shell_class;
    struct {} candidate_list_class;
  };

#define CL(W)	(&((struct CandidateList *)(W))->candidate_list)

static XtResource resources[] = {
};

static void
initialize (Widget req, Widget new, ArgList args, Cardinal *num_args)
{
  CL (new)->vport_w
    = XtVaCreateManagedWidget ("viewport", viewportWidgetClass, new,
			       XtNallowHoriz, True,
			       NULL);
  CL (new)->list_w
    = XtVaCreateManagedWidget ("list", listWidgetClass, CL (new)->vport_w,
			       XtNdefaultColumns, 1,
			       XtNforceColumns, True,
			       NULL);
}

static Boolean
set_values (Widget w, Widget req, Widget new, ArgList args, Cardinal *num_args)
{
  Boolean need_redisplay = False;

  printf ("CandidateList::set_values\n");

  return need_redisplay;
}

static XtGeometryResult
geometry_manager (Widget w,
		  XtWidgetGeometry *request, XtWidgetGeometry *result)
{
  return XtGeometryYes;
}

static XtActionsRec actions[] = {
};

void
candidate_list_set_strings (Widget w, String const *list, Cardinal nstrings)
{
  XawListChange (CL (w)->list_w, (String *)list, nstrings, 0, TRUE);
}

void
candidate_list_set_highlight (Widget w, int index)
{
  XawListHighlight (CL (w)->list_w, index);
}

struct CandidateListClass candidateListClassRec = {
  {
    .core_class =
      {
	superclass:		(WidgetClass) SUPERCLASS,
	class_name:		"CandidateList",
	widget_size:		sizeof (struct CandidateList),
	class_initialize:	NULL,
	class_inited:		False,
	initialize:		initialize,
	realize:		XtInheritRealize,

	actions:		actions,
	num_actions:		XtNumber (actions),
	resources:		resources,
	num_resources:		XtNumber (resources),
	xrm_class:		NULLQUARK,

	resize:			XtInheritResize,
	expose:			XtInheritExpose,

	set_values:		set_values,
	set_values_almost:	XtInheritSetValuesAlmost,

	accept_focus:		XtInheritAcceptFocus,
	version:		XtVersion,
	query_geometry:		XtInheritQueryGeometry,
	display_accelerator:	XtInheritDisplayAccelerator,
      },
    .composite_class =
      {
	geometry_manager:	geometry_manager,
	change_managed:		XtInheritChangeManaged,
	insert_child:		XtInheritInsertChild,
	delete_child:		XtInheritDeleteChild,
	extension:		NULL,
      },
  }
};
