/* main.c -- main module for AIME Xaw user-interface.
   Copyright (C) 2002  TAKAI Kousuke <tak@kmc.gr.jp>.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.  */

/* $Id: main.c,v 1.2 2002/03/26 10:47:00 taka Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <err.h>

#include <X11/Xaw/Label.h>

#include "aimetrans.h"
#include "ui-xaw.h"
#include "candlist.h"

static void
process_fd_input (XtPointer client_data, int *fdp, XtInputId *input_id)
{
  aimetrans_process_fd_input ((struct aimetrans *) client_data);
}

int
main (int argc, char *argv[])
{
  XtAppContext app;
  Widget toplevel;
  struct aimetrans *x;
  struct xawui_cb_data cb_data;

  static XrmOptionDescRec options[] = {
  };

  static String fallback_resources[] = {
#include "Aime-Xaw.h"
    NULL
  };

  XtSetLanguageProc (NULL, NULL, NULL);

  toplevel = XtOpenApplication (&app, "Aime-Xaw", options, XtNumber (options),
				&argc, argv, fallback_resources,
				applicationShellWidgetClass, NULL, 0);

  if (!(x = aimetrans_open ("local", NULL)))
    err (1, "cannot establish connection to aime server");

  if (aimetrans_fd_input_needed (x))
    XtAppAddInput (app, x->fd, (XtPointer) XtInputReadMask,
		   process_fd_input, (XtPointer) x);

  cb_data.mode_label
    = XtCreateManagedWidget ("mode", labelWidgetClass, toplevel, NULL, 0);

  cb_data.candidate_shell
    = XtCreatePopupShell ("candidateWindow", candidateListWidgetClass,
			  toplevel, NULL, 0);
  cb_data.candidates = NULL;

  x->cb_data = &cb_data;

  XtRealizeWidget (toplevel);
  XtAppMainLoop (app);
  return 0;
}
