#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "aimetrans.h"
#include "ui-xaw.h"

int
aimetrans_cb_onoff (struct aimetrans *const ax, bool on)
{
  struct xawui_cb_data *const data = ax->cb_data;

  printf ("AIME %s\n", on ? "ON" : "OFF");
  XtVaSetValues (data->mode_label, XtNsensitive, (Bool) on, NULL);

  return 0;
}

int
aimetrans_cb_mode (struct aimetrans *const ax, enum aimetrans_mode mode)
{
  struct xawui_cb_data *const data = ax->cb_data;

  printf ("AIME MODE %d\n", (int) mode);
  XtVaSetValues (data->mode_label, XtNlabel,
		 mode == AMODE_ASCII ? "ASCII" :
		 mode == AMODE_HIRA ? "" :
		 mode == AMODE_KATA ? "" :
		 mode == AMODE_ZEN_ASCII ? "" : "",
		 NULL);

  return 0;
}
