/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.Day;
import ajd4jp.EarthlyBranch;
import ajd4jp.LunisolarYear;
import ajd4jp.STCD;

public class Age {
    private AJD start;

    public Age(Day birthday) {
        this.start = new AJD(birthday.getAJD()).trim();
    }

    private static int get(AJD birthday, AJD target, int sub) {
        AJD s = new AJD(birthday);
        AJD last = new AJD(s);
        AJD e = new AJD(target);
        while (true) {
            last = last.addDay(-1).addDay(sub);
            try {
                last = new AJD(e.getYear(), last.getMonth(), last.getDay());
            }
            catch (Exception ex) {
                continue;
            }
            break;
        }
        int ret = e.getYear() - s.getYear() - 1;
        if (last.compareTo(e) < 0) {
            ++ret;
        }
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    private static int calcAsia(int s, int e) {
        int ret = e - s + 1;
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    private int getS(AJD end) {
        return Age.calcAsia(this.start.getYear(), end.getYear());
    }

    private int getLS(AJD end) {
        return Age.calcAsia(LunisolarYear.getLunisolarYear(this.start).getYear(), LunisolarYear.getLunisolarYear(end).getYear());
    }

    private int getST(AJD end) {
        return Age.calcAsia(new STCD(this.start).getYear(), new STCD(end).getYear());
    }

    public int getAge(Reckoning type, Day target) {
        AJD end = new AJD(target.getAJD()).trim();
        switch (type) {
            case DAY: {
                return Age.get(this.start, end, -1);
            }
            case TIME: {
                return Age.get(this.start, end, 0);
            }
            case ASIA_SOLAR: {
                return this.getS(end);
            }
            case ASIA_LUNISOLAR: {
                return this.getLS(end);
            }
            case ASIA_SOLAR_TERM: {
                return this.getST(end);
            }
        }
        return -1;
    }

    public AJD getDate(Reckoning type, int age) {
        block4 : switch (type) {
            case DAY: 
            case TIME: {
                if (age == 0) {
                    return this.start;
                }
                if (age <= 0) break;
                int y = this.start.getYear() + age;
                AJD ret = this.start;
                while (true) {
                    try {
                        ret = new AJD(y, ret.getMonth(), ret.getDay());
                    }
                    catch (Exception exception) {
                        ret = ret.addDay(1);
                        continue;
                    }
                    break;
                }
                if (type == Reckoning.TIME) {
                    return ret;
                }
                return ret.addDay(-1);
            }
            case ASIA_SOLAR: {
                if (age == 1) {
                    return this.start;
                }
                if (age <= 1) break;
                try {
                    return new AJD(this.start.getYear() + age - 1, 1, 1);
                }
                catch (Exception y) {
                    break;
                }
            }
            case ASIA_LUNISOLAR: {
                if (age == 1) {
                    return this.start;
                }
                if (age <= 1) break;
                int y = LunisolarYear.getLunisolarYear(this.start).getYear() + age - 1;
                if (y == 0) {
                    y = 1;
                }
                try {
                    return LunisolarYear.getLunisolarYear(y).getLSCD(1, false, 1).toAJD();
                }
                catch (Exception ret) {
                    break;
                }
            }
            case ASIA_SOLAR_TERM: {
                if (age == 1) {
                    return this.start;
                }
                if (age <= 1) break;
                int sy = this.start.getYear() + age - 2;
                while (true) {
                    if (sy != 0) {
                        try {
                            AJD[] dy = STCD.Doyo.SPRING.getDoyo(sy, new EarthlyBranch[0]);
                            AJD fst = dy[dy.length - 1].addDay(1);
                            if (this.getAge(type, fst) == age) {
                                return fst;
                            }
                        }
                        catch (Exception e) {
                            break block4;
                        }
                    }
                    ++sy;
                }
            }
        }
        return null;
    }

    public static enum Reckoning {
        DAY,
        TIME,
        ASIA_SOLAR,
        ASIA_LUNISOLAR,
        ASIA_SOLAR_TERM;

    }
}

