/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJDException;
import ajd4jp.Holiday;
import ajd4jp.Holy;
import java.io.Serializable;

abstract class HolidayType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Holy start = null;
    private Holy end = null;

    HolidayType(String n, Holy s, Holy e) {
        this.name = n;
        this.start = s;
        this.end = e;
    }

    String getName(int yyyy) {
        if (this.isHit(yyyy)) {
            return this.name;
        }
        return null;
    }

    private boolean isHit(int yyyy) {
        int ey;
        int sy;
        if (yyyy < 1868) {
            return false;
        }
        if (this.start != null && (sy = this.start.getYear()) > yyyy) {
            return false;
        }
        return this.end == null || (ey = this.end.getYear()) >= yyyy;
    }

    abstract Holy[] get(int var1) throws AJDException;

    static Holy[] select(int yyyy, Holiday h, HolidayType[] hd) {
        for (int i = 0; i < hd.length; ++i) {
            if (!hd[i].isHit(yyyy)) continue;
            return hd[i].getHoliday(h, yyyy);
        }
        return null;
    }

    private Holy[] getHoliday(Holiday h, int year) {
        Holy[] ret = null;
        try {
            ret = this.get(year);
            for (int i = 0; i < ret.length; ++i) {
                ret[i].set(h);
            }
        }
        catch (AJDException aJDException) {
            // empty catch block
        }
        return ret;
    }
}

