/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.format;

import ajd4jp.Day;
import ajd4jp.Era;
import ajd4jp.format.Format;
import ajd4jp.format.Two;
import ajd4jp.format.TwoHalfArabia;

public class JapaneseYearF
extends Format {
    private Era e;
    Era.Year jp;

    public JapaneseYearF(Era era, Two num) {
        super(num);
        this.e = era;
        if (this.e == null) {
            this.e = Era.KANJI;
        }
    }

    public JapaneseYearF(Two num) {
        this(Era.KANJI, num);
    }

    public JapaneseYearF() {
        this(Era.KANJI, new TwoHalfArabia(new Two.Rule[0]));
    }

    @Override
    int getNum(Day date) {
        this.jp = new Era.Year(date);
        return this.jp.getYear();
    }

    @Override
    String getHead() {
        String h = "";
        ajd4jp.Era era = this.jp.getEra();
        if (era != null) {
            block0 : switch (this.e) {
                case KANJI: {
                    h = era.getName();
                    break;
                }
                case FULL: {
                    switch (era) {
                        case MEIJI: {
                            h = "\uff2d";
                            break;
                        }
                        case TAISHO: {
                            h = "\uff34";
                            break;
                        }
                        case SHOWA: {
                            h = "\uff33";
                            break;
                        }
                        case HEISEI: {
                            h = "\uff28";
                        }
                    }
                    break;
                }
                case HALF: {
                    switch (era) {
                        case MEIJI: {
                            h = "M";
                            break block0;
                        }
                        case TAISHO: {
                            h = "T";
                            break block0;
                        }
                        case SHOWA: {
                            h = "S";
                            break block0;
                        }
                        case HEISEI: {
                            h = "H";
                        }
                    }
                }
            }
        }
        return h;
    }

    public static enum Era {
        KANJI,
        HALF,
        FULL;

    }
}

