/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.AJDException;
import ajd4jp.orrery.ETD;
import ajd4jp.orrery.tool.JPLItem;
import ajd4jp.orrery.tool.MapXYZ;
import ajd4jp.util.Calc;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.util.HashMap;

public class Ephemeris {
    private static File parent;
    private static MapXYZ map;
    private static ETD start;
    private static ETD end;
    private static HashMap<String, BigDecimal> fix;
    static BigDecimal EMB;
    static BigDecimal AU;

    private Ephemeris() {
    }

    static long floor(BigDecimal b) {
        return (long)Math.floor(b.doubleValue());
    }

    static BigDecimal getParam(String key) {
        return fix.get(key);
    }

    public static void init(String dir) throws Exception {
        parent = new File(dir);
        map = MapXYZ.load(parent);
        fix = new HashMap();
        for (int i = 0; i < Ephemeris.map.key.length; ++i) {
            fix.put(Ephemeris.map.key[i], Ephemeris.map.val[i]);
        }
        start = new ETD(Ephemeris.map.start_jed);
        end = new ETD(Ephemeris.map.end_jed);
        EMB = Calc.div(BigDecimal.ONE, fix.get("EMRAT").add(BigDecimal.ONE));
        AU = fix.get("AU");
    }

    static RandomAccessFile open(JPLItem p) throws IOException {
        return new RandomAccessFile(new File(parent, p.getFileName()), "r");
    }

    static void check() throws AJDException {
        if (start == null || end == null) {
            throw new AJDException("Ephemeris.init()\u304c\u547c\u3073\u51fa\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    public static boolean isRange(ETD jed) {
        if (start == null || end == null) {
            return false;
        }
        return start.compareTo(jed) <= 0 && end.compareTo(jed) > 0;
    }

    static DE getBlockNo(ETD jed, int days) throws AJDException {
        if (!Ephemeris.isRange(jed)) {
            throw new AJDException("\u5929\u4f53\u66a6\u306e\u65e5\u6642\u7bc4\u56f2\u5916");
        }
        return new DE(jed.getJED().subtract(start.getJED()), days);
    }

    static int getDays(int no) {
        return Ephemeris.map.step_day[no];
    }

    static int getCount(int no) {
        return Ephemeris.map.data_count[no];
    }

    static byte[] getBuffer() {
        return new byte[Ephemeris.map.size];
    }

    static {
        map = null;
        start = null;
        end = null;
        fix = new HashMap();
    }

    static class DE {
        int no;
        BigDecimal pos;

        DE(BigDecimal sub, int days) {
            this.no = (int)Ephemeris.floor(Calc.div(sub, days));
            sub = sub.subtract(new BigDecimal(this.no * days));
            this.pos = Calc.div(sub.multiply(new BigDecimal(2)), new BigDecimal(days)).subtract(BigDecimal.ONE);
        }
    }
}

