/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.contexts.ContextEvent;
import org.eclipse.ui.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.contexts.AbstractContextManager;
import org.eclipse.ui.internal.contexts.Context;
import org.eclipse.ui.internal.contexts.ContextDefinition;
import org.eclipse.ui.internal.contexts.ContextRegistryEvent;
import org.eclipse.ui.internal.contexts.ExtensionContextRegistry;
import org.eclipse.ui.internal.contexts.IContextRegistry;
import org.eclipse.ui.internal.contexts.IContextRegistryListener;
import org.eclipse.ui.internal.contexts.IMutableContextManager;
import org.eclipse.ui.internal.util.Util;

public final class MutableContextManager
extends AbstractContextManager
implements IMutableContextManager {
    private Map contextContextBindingsByParentContextId = new HashMap();
    private Map contextDefinitionsById = new HashMap();
    private IContextRegistry contextRegistry;
    private Map contextsById = new WeakHashMap();
    private Set definedContextIds = new HashSet();
    private Set enabledContextIds = new HashSet();
    static /* synthetic */ Class class$0;

    static boolean isContextDefinitionChildOf(String ancestor, String id, Map contextDefinitionsById) {
        HashSet<String> visited = new HashSet<String>();
        while (id != null && !visited.contains(id)) {
            ContextDefinition contextDefinition = (ContextDefinition)contextDefinitionsById.get(id);
            visited.add(id);
            if (contextDefinition == null || !Util.equals(id = contextDefinition.getParentId(), ancestor)) continue;
            return true;
        }
        return false;
    }

    public MutableContextManager() {
        this(new ExtensionContextRegistry(Platform.getExtensionRegistry()));
    }

    public MutableContextManager(IContextRegistry contextRegistry) {
        if (contextRegistry == null) {
            throw new NullPointerException();
        }
        this.contextRegistry = contextRegistry;
        this.contextRegistry.addContextRegistryListener(new IContextRegistryListener(){

            public void contextRegistryChanged(ContextRegistryEvent contextRegistryEvent) {
                MutableContextManager.this.readRegistry();
            }
        });
        this.readRegistry();
    }

    public IContext getContext(String contextId) {
        if (contextId == null) {
            throw new NullPointerException();
        }
        Context context = (Context)this.contextsById.get(contextId);
        if (context == null) {
            context = new Context(contextId);
            this.updateContext(context);
            this.contextsById.put(contextId, context);
        }
        return context;
    }

    public SortedSet getDefinedContextIds() {
        return new DepthSortedContextIdSet(this.definedContextIds);
    }

    public SortedSet getEnabledContextIds() {
        return new DepthSortedContextIdSet(this.enabledContextIds);
    }

    private void notifyContexts(Map contextEventsByContextId) {
        Iterator iterator = contextEventsByContextId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextId = (String)entry.getKey();
            ContextEvent contextEvent = (ContextEvent)entry.getValue();
            Context context = (Context)this.contextsById.get(contextId);
            if (context == null) continue;
            context.fireContextChanged(contextEvent);
        }
    }

    private void readRegistry() {
        ArrayList contextDefinitions = new ArrayList();
        contextDefinitions.addAll(this.contextRegistry.getContextDefinitions());
        HashMap contextDefinitionsById = new HashMap(ContextDefinition.contextDefinitionsById(contextDefinitions, false));
        Iterator<Object> iterator = contextDefinitionsById.values().iterator();
        while (iterator.hasNext()) {
            ContextDefinition contextDefinition = (ContextDefinition)iterator.next();
            String name = contextDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator.remove();
        }
        iterator = contextDefinitionsById.keySet().iterator();
        while (iterator.hasNext()) {
            if (MutableContextManager.isContextDefinitionChildOf(null, (String)iterator.next(), contextDefinitionsById)) continue;
            iterator.remove();
        }
        this.contextDefinitionsById = contextDefinitionsById;
        boolean definedContextIdsChanged = false;
        HashSet definedContextIds = new HashSet(contextDefinitionsById.keySet());
        Set previouslyDefinedContextIds = null;
        if (!definedContextIds.equals(this.definedContextIds)) {
            previouslyDefinedContextIds = this.definedContextIds;
            this.definedContextIds = definedContextIds;
            definedContextIdsChanged = true;
        }
        Map contextEventsByContextId = this.updateContexts(this.contextsById.keySet());
        if (definedContextIdsChanged) {
            this.fireContextManagerChanged(new ContextManagerEvent(this, definedContextIdsChanged, false, previouslyDefinedContextIds, null));
        }
        if (contextEventsByContextId != null) {
            this.notifyContexts(contextEventsByContextId);
        }
    }

    public void setEnabledContextIds(Set enabledContextIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledContextIds = Util.safeCopy(enabledContextIds, (Class)clazz);
        boolean contextManagerChanged = false;
        Map contextEventsByContextId = null;
        Set previouslyEnabledContextIds = null;
        if (!this.enabledContextIds.equals(enabledContextIds)) {
            previouslyEnabledContextIds = this.enabledContextIds;
            this.enabledContextIds = enabledContextIds;
            contextManagerChanged = true;
            contextEventsByContextId = this.updateContexts(this.contextsById.keySet());
        }
        if (contextEventsByContextId != null) {
            this.notifyContexts(contextEventsByContextId);
        }
        if (contextManagerChanged) {
            this.fireContextManagerChanged(new ContextManagerEvent(this, false, true, null, previouslyEnabledContextIds));
        }
    }

    private ContextEvent updateContext(Context context) {
        Set cfr_ignored_0 = (Set)this.contextContextBindingsByParentContextId.get(context.getId());
        ContextDefinition contextDefinition = (ContextDefinition)this.contextDefinitionsById.get(context.getId());
        boolean definedChanged = context.setDefined(contextDefinition != null);
        boolean enabledChanged = context.setEnabled(this.enabledContextIds.contains(context.getId()));
        boolean nameChanged = context.setName(contextDefinition != null ? contextDefinition.getName() : null);
        boolean parentIdChanged = context.setParentId(contextDefinition != null ? contextDefinition.getParentId() : null);
        if (definedChanged || enabledChanged || nameChanged || parentIdChanged) {
            return new ContextEvent(context, definedChanged, enabledChanged, nameChanged, parentIdChanged);
        }
        return null;
    }

    private Map updateContexts(Collection contextIds) {
        TreeMap<String, ContextEvent> contextEventsByContextId = new TreeMap<String, ContextEvent>();
        Iterator iterator = contextIds.iterator();
        while (iterator.hasNext()) {
            ContextEvent contextEvent;
            String contextId = (String)iterator.next();
            Context context = (Context)this.contextsById.get(contextId);
            if (context == null || (contextEvent = this.updateContext(context)) == null) continue;
            contextEventsByContextId.put(contextId, contextEvent);
        }
        return contextEventsByContextId;
    }

    private class ContextIdDepthComparator
    implements Comparator {
        ContextIdDepthComparator() {
        }

        public final int compare(Object object1, Object object2) {
            String parentId;
            String contextId1 = (String)object1;
            String contextId2 = (String)object2;
            int depth1 = 0;
            IContext context = MutableContextManager.this.getContext(contextId1);
            try {
                parentId = context.getParentId();
                while (parentId != null) {
                    ++depth1;
                    context = MutableContextManager.this.getContext(parentId);
                    parentId = context.getParentId();
                }
            }
            catch (NotDefinedException notDefinedException) {}
            int depth2 = 0;
            context = MutableContextManager.this.getContext(contextId2);
            try {
                parentId = context.getParentId();
                while (parentId != null) {
                    ++depth2;
                    context = MutableContextManager.this.getContext(parentId);
                    parentId = context.getParentId();
                }
            }
            catch (NotDefinedException notDefinedException) {}
            int compare = depth2 - depth1;
            if (compare == 0) {
                compare = contextId1.compareTo(contextId2);
            }
            return compare;
        }
    }

    private class DepthSortedContextIdSet
    extends TreeSet {
        DepthSortedContextIdSet(Set contextIds) {
            super(new ContextIdDepthComparator());
            this.addAll(contextIds);
        }
    }
}

