/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractUIPlugin
extends Plugin {
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private DialogSettings dialogSettings = null;
    private CompatibilityPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry = null;
    private BundleListener bundleListener;

    public AbstractUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
    }

    public AbstractUIPlugin() {
    }

    protected ImageRegistry createImageRegistry() {
        return new ImageRegistry();
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new CompatibilityPreferenceStore();
            this.preferenceStore.initialize();
        }
        return this.preferenceStore;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    protected void initializeDefaultPluginPreferences() {
        this.loadPreferenceStore();
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadDialogSettings() {
        this.dialogSettings = new DialogSettings("Workbench");
        String readWritePath = this.getStateLocation().append(FN_DIALOG_SETTINGS).toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                this.dialogSettings.load(readWritePath);
                return;
            }
            catch (IOException iOException) {
                this.dialogSettings = new DialogSettings("Workbench");
                return;
            }
        }
        URL dsURL = BundleUtility.find(this.getBundle(), FN_DIALOG_SETTINGS);
        if (dsURL == null) {
            return;
        }
        InputStream is = null;
        try {
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                this.dialogSettings.load((Reader)reader);
            }
            catch (IOException iOException) {
                this.dialogSettings = new DialogSettings("Workbench");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is == null) return;
        is.close();
    }

    protected void loadPreferenceStore() {
    }

    protected void refreshPluginActions() {
        if (Workbench.getInstance() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WWinPluginAction.refreshActionList();
            }
        });
    }

    protected void saveDialogSettings() {
        if (this.dialogSettings == null) {
            return;
        }
        try {
            String readWritePath = this.getStateLocation().append(FN_DIALOG_SETTINGS).toOSString();
            this.dialogSettings.save(readWritePath);
        }
        catch (IOException iOException) {}
    }

    protected void savePreferenceStore() {
        this.savePluginPreferences();
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final BundleContext fc = context;
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == AbstractUIPlugin.this.getBundle() && event.getType() == 2) {
                    AbstractUIPlugin.this.refreshPluginActions();
                    fc.removeBundleListener((BundleListener)this);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.bundleListener != null) {
                context.removeBundleListener(this.bundleListener);
            }
            this.saveDialogSettings();
            this.savePreferenceStore();
            this.preferenceStore = null;
            this.imageRegistry = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtility.isReady(bundle)) {
            return null;
        }
        URL fullPathString = BundleUtility.find(bundle, imageFilePath);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(imageFilePath);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (fullPathString == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    private class CompatibilityPreferenceStore
    implements IPersistentPreferenceStore {
        private boolean listenerAdded = false;
        private Preferences prefs = null;
        private ListenerList listeners = new ListenerList();
        private boolean silentRunning = false;

        void initialize() {
            if (this.prefs != null) {
                return;
            }
            this.prefs = AbstractUIPlugin.this.getPluginPreferences();
            if (!this.listenerAdded) {
                this.prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(this){
                    final /* synthetic */ CompatibilityPreferenceStore this$1;
                    {
                        this.this$1 = compatibilityPreferenceStore;
                    }

                    public void propertyChange(Preferences.PropertyChangeEvent event) {
                        if (!CompatibilityPreferenceStore.access$0(this.this$1)) {
                            this.this$1.firePropertyChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
                        }
                    }
                });
                this.listenerAdded = true;
            }
        }

        private Preferences getPrefs() {
            if (this.prefs == null) {
                this.initialize();
            }
            return this.prefs;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            if (this.listeners.isEmpty()) {
                return;
            }
            Object[] list = this.listeners.getListeners();
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < list.length) {
                IPropertyChangeListener listener = (IPropertyChangeListener)list[i];
                Platform.run((ISafeRunnable)new SafeRunnable(this, JFaceResources.getString((String)"PreferenceStore.changeError"), listener, event){
                    final /* synthetic */ CompatibilityPreferenceStore this$1;
                    private final /* synthetic */ IPropertyChangeListener val$listener;
                    private final /* synthetic */ PropertyChangeEvent val$event;
                    {
                        this.this$1 = compatibilityPreferenceStore;
                        this.val$listener = iPropertyChangeListener;
                        this.val$event = propertyChangeEvent;
                    }

                    public void run() {
                        this.val$listener.propertyChange(this.val$event);
                    }
                });
                ++i;
            }
        }

        public boolean contains(String name) {
            return this.getPrefs().contains(name);
        }

        public boolean getBoolean(String name) {
            return this.getPrefs().getBoolean(name);
        }

        public boolean getDefaultBoolean(String name) {
            return this.getPrefs().getDefaultBoolean(name);
        }

        public double getDefaultDouble(String name) {
            return this.getPrefs().getDefaultDouble(name);
        }

        public float getDefaultFloat(String name) {
            return this.getPrefs().getDefaultFloat(name);
        }

        public int getDefaultInt(String name) {
            return this.getPrefs().getDefaultInt(name);
        }

        public long getDefaultLong(String name) {
            return this.getPrefs().getDefaultLong(name);
        }

        public String getDefaultString(String name) {
            return this.getPrefs().getDefaultString(name);
        }

        public double getDouble(String name) {
            return this.getPrefs().getDouble(name);
        }

        public float getFloat(String name) {
            return this.getPrefs().getFloat(name);
        }

        public int getInt(String name) {
            return this.getPrefs().getInt(name);
        }

        public long getLong(String name) {
            return this.getPrefs().getLong(name);
        }

        public String getString(String name) {
            return this.getPrefs().getString(name);
        }

        public boolean isDefault(String name) {
            return this.getPrefs().isDefault(name);
        }

        public boolean needsSaving() {
            return this.getPrefs().needsSaving();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void putValue(String name, String value) {
            try {
                this.silentRunning = true;
                this.getPrefs().setValue(name, value);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.silentRunning = false;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.silentRunning = false;
                return;
            }
        }

        public void setDefault(String name, double value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setDefault(String name, float value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setDefault(String name, int value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setDefault(String name, long value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setDefault(String name, String value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setDefault(String name, boolean value) {
            this.getPrefs().setDefault(name, value);
        }

        public void setToDefault(String name) {
            this.getPrefs().setToDefault(name);
        }

        public void setValue(String name, double value) {
            this.getPrefs().setValue(name, value);
        }

        public void setValue(String name, float value) {
            this.getPrefs().setValue(name, value);
        }

        public void setValue(String name, int value) {
            this.getPrefs().setValue(name, value);
        }

        public void setValue(String name, long value) {
            this.getPrefs().setValue(name, value);
        }

        public void setValue(String name, String value) {
            this.getPrefs().setValue(name, value);
        }

        public void setValue(String name, boolean value) {
            this.getPrefs().setValue(name, value);
        }

        public void save() throws IOException {
            AbstractUIPlugin.this.savePreferenceStore();
        }

        static /* synthetic */ boolean access$0(CompatibilityPreferenceStore compatibilityPreferenceStore) {
            return compatibilityPreferenceStore.silentRunning;
        }
    }
}

