/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.stats;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceBundleStats {
    private String pluginId;
    private String fileName;
    private int keyCount = 0;
    private int keySize = 0;
    private int valueSize = 0;
    private long hashSize = 0L;
    private long fileSize = 0L;

    private static int sizeOf(String value) {
        return 44 + 2 * value.length();
    }

    private static int sizeOf(Properties value) {
        return (int)Math.round(44.0 + (16.0 + (double)value.size() * 1.25 * 4.0) + (double)(24 * value.size()));
    }

    public ResourceBundleStats(String pluginId, String fileName, URL input) {
        this.pluginId = pluginId;
        this.fileName = fileName;
        this.initialize(input);
    }

    public ResourceBundleStats(String pluginId, String fileName, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.fileName = fileName;
        this.initialize(bundle);
    }

    private void initialize(ResourceBundle bundle) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            this.keySize += ResourceBundleStats.sizeOf(key);
            this.valueSize += ResourceBundleStats.sizeOf(bundle.getString(key));
            ++this.keyCount;
        }
    }

    /*
     * Exception decompiling
     */
    private void initialize(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 139->145)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getHashSize() {
        return this.hashSize;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public long getTotalSize() {
        return (long)(this.keySize + this.valueSize) + this.hashSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

