/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.JobRoot;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;

public class InstallOperation
extends FeatureOperation
implements IInstallFeatureOperation {
    private static final String KEY_OLD = "OperationsManager.error.old";
    private IFeatureReference[] optionalFeatures;
    private IFeature[] unconfiguredOptionalFeatures;
    private IVerificationListener verifier;

    public InstallOperation(IConfiguredSite site, IFeature feature, IFeatureReference[] optionalFeatures, IFeature[] unconfiguredOptionalElements, IVerificationListener verifier) {
        super(site, feature);
        IFeature[] installed = UpdateUtils.getInstalledFeatures(feature);
        if (installed.length > 0) {
            this.oldFeature = installed[0];
        }
        this.unconfiguredOptionalFeatures = unconfiguredOptionalElements;
        this.optionalFeatures = optionalFeatures;
        this.verifier = verifier;
    }

    public IFeatureReference[] getOptionalFeatures() {
        return this.optionalFeatures;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        boolean reinstall = false;
        if (this.oldFeature != null && this.feature.getVersionedIdentifier().equals(this.oldFeature.getVersionedIdentifier())) {
            reinstall = true;
        }
        this.setOptionalFeatures();
        if (this.optionalFeatures == null) {
            this.targetSite.install(this.feature, this.verifier, pm);
        } else {
            this.targetSite.install(this.feature, this.optionalFeatures, this.verifier, pm);
        }
        if (!reinstall && this.oldFeature != null) {
            IInstallConfiguration config;
            this.preserveOptionalState();
            boolean oldSuccess = FeatureOperation.unconfigure(this.oldFeature, null);
            if (!oldSuccess && !UpdateUtils.isNestedChild(config = SiteManager.getLocalSite().getCurrentConfiguration(), this.oldFeature)) {
                String message = Policy.bind(KEY_OLD, this.oldFeature.getLabel());
                Status status = new Status(4, UpdateUtils.getPluginId(), 0, message, null);
                throw new CoreException((IStatus)status);
            }
        }
        return true;
    }

    private void preserveOptionalState() {
        if (this.unconfiguredOptionalFeatures == null) {
            return;
        }
        int i = 0;
        while (i < this.unconfiguredOptionalFeatures.length) {
            try {
                IFeature localFeature = UpdateUtils.getLocalFeature(this.targetSite, this.unconfiguredOptionalFeatures[i]);
                if (localFeature != null) {
                    this.targetSite.unconfigure(localFeature);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private void setOptionalFeatures() {
        try {
            if (this.optionalFeatures == null && UpdateUtils.hasOptionalFeatures(this.feature)) {
                JobRoot jobRoot = new JobRoot(this);
                IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
                HashSet set = new HashSet();
                boolean update = this.oldFeature != null;
                boolean patch = UpdateUtils.isPatch(this.feature);
                FeatureHierarchyElement[] elements = jobRoot.getElements();
                int i = 0;
                while (i < elements.length) {
                    elements[i].addCheckedOptionalFeatures(update, patch, config, set);
                    ++i;
                }
                this.optionalFeatures = new IFeatureReference[set.size()];
                set.toArray(this.optionalFeatures);
                this.unconfiguredOptionalFeatures = jobRoot.getUnconfiguredOptionalFeatures(config, this.targetSite);
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
    }
}

