/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class SiteSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries = new IUpdateSearchQuery[]{new Query()};
    private static final String CATEGORY_ID = "org.eclipse.update.core.unified-search";

    public SiteSearchCategory() {
        super(CATEGORY_ID);
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    private static class Query
    implements IUpdateSearchQuery {
        Query() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(ISite site, String[] categoriesToSkip, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector, IProgressMonitor monitor) {
            int i;
            ISiteFeatureReference[] refs = site.getFeatureReferences();
            HashSet<String> ignores = new HashSet<String>();
            if (categoriesToSkip != null) {
                i = 0;
                while (i < categoriesToSkip.length) {
                    ignores.add(categoriesToSkip[i]);
                    ++i;
                }
            }
            monitor.beginTask("", refs.length);
            i = 0;
            while (i < refs.length) {
                ISiteFeatureReference ref = refs[i];
                boolean skipFeature = false;
                if (monitor.isCanceled()) {
                    return;
                }
                if (ignores.size() > 0) {
                    ICategory[] categories = ref.getCategories();
                    int j = 0;
                    while (j < categories.length) {
                        ICategory category = categories[j];
                        if (ignores.contains(category.getName())) {
                            skipFeature = true;
                            break;
                        }
                        ++j;
                    }
                }
                try {
                    try {
                        if (!skipFeature && filter.accept(ref)) {
                            IFeature feature = ref.getFeature(null);
                            if (filter.accept(feature)) {
                                collector.accept(feature);
                            }
                            monitor.subTask(feature.getLabel());
                        }
                    }
                    catch (CoreException e) {
                        System.out.println((Object)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    monitor.worked(1);
                    throw throwable;
                }
                {
                    Object var12_13 = null;
                }
                monitor.worked(1);
                ++i;
            }
            return;
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }
}

