/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AudioUtils {
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.speech.AudioUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static void mixFile(File output, File[] inputs, AudioFileFormat.Type type) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = null;
        File tmpOut = File.createTempFile("newTmp", ".wav");
        log.trace((Object)("createTmp:" + tmpOut));
        log.trace((Object)("input base:" + inputs[0]));
        audioInputStream = AudioSystem.getAudioInputStream(inputs[0]);
        AudioFormat audioFormat = audioInputStream.getFormat();
        log.trace((Object)("format:" + audioFormat));
        FileOutputStream fout = new FileOutputStream(tmpOut);
        int readBytes = 0;
        byte[] bytedata = new byte[10280];
        long readedByte = 0L;
        while (readBytes != -1) {
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            fout.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        log.trace((Object)("written:" + readedByte + " " + inputs[0]));
        audioInputStream.close();
        int i = 1;
        while (i < inputs.length) {
            if (inputs[i].exists()) {
                readBytes = 0;
                readedByte = 0L;
                log.trace((Object)("read:" + inputs[i]));
                if (inputs[i].length() > 0L) {
                    AudioInputStream tmpInput = AudioSystem.getAudioInputStream(inputs[i]);
                    AudioInputStream readInput = AudioSystem.getAudioInputStream(audioFormat, tmpInput);
                    while (readBytes != -1) {
                        readBytes = readInput.read(bytedata, 0, bytedata.length);
                        if (readBytes >= 0) {
                            fout.write(bytedata, 0, readBytes);
                        }
                        readedByte += (long)readBytes;
                    }
                    log.trace((Object)("written:" + readedByte + " " + inputs[i]));
                    readInput.close();
                } else {
                    log.debug((Object)("input length: 0" + inputs[i]));
                }
            } else {
                log.debug((Object)("input not found:" + inputs[i]));
            }
            ++i;
        }
        fout.close();
        log.trace((Object)("output.length:" + tmpOut.length() + ",framesize:" + audioFormat.getChannels() * audioFormat.getFrameSize()));
        AudioInputStream finalInput = new AudioInputStream(new FileInputStream(tmpOut), audioFormat, tmpOut.length() / (long)(audioFormat.getChannels() * audioFormat.getFrameSize()));
        long bytes = AudioSystem.write(finalInput, type, output);
        log.trace((Object)("final write:" + output.getAbsolutePath()));
        log.trace((Object)("final write bytes:" + bytes));
        finalInput.close();
        boolean ret = tmpOut.delete();
        log.trace((Object)("tmp delete:" + ret));
    }
}

