/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class JavaClipAudioPlayer
implements AudioPlayer {
    private volatile boolean paused;
    private volatile boolean cancelled = false;
    private volatile Clip currentClip;
    private Object clipLock = new Object();
    private float volume = 1.0f;
    private boolean debug = false;
    private BulkTimer timer = new BulkTimer();
    private AudioFormat defaultFormat;
    private AudioFormat currentFormat = this.defaultFormat = new AudioFormat(8000.0f, 16, 1, true, true);
    private boolean firstSample = true;
    private int curIndex = 0;
    private byte[] outputData;
    private LineListener lineListener = new JavaClipLineListener();
    private long openFailDelayMs;
    private long totalOpenFailDelayMs;

    public JavaClipAudioPlayer() {
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
        this.openFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.openFailDelayMs", 0L);
        this.totalOpenFailDelayMs = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.totalOpenFailDelayMs", 0L);
        this.setPaused(false);
    }

    public synchronized void setAudioFormat(AudioFormat format) {
        this.currentFormat = format;
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (!this.paused) {
            this.setPaused(true);
            if (this.currentClip != null) {
                this.currentClip.stop();
            }
            JavaClipAudioPlayer javaClipAudioPlayer = this;
            synchronized (javaClipAudioPlayer) {
                this.notifyAll();
            }
        }
    }

    public synchronized void resume() {
        if (this.paused) {
            this.setPaused(false);
            if (this.currentClip != null) {
                this.currentClip.start();
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.currentClip != null) {
            this.currentClip.stop();
            this.currentClip.close();
        }
        JavaClipAudioPlayer javaClipAudioPlayer = this;
        synchronized (javaClipAudioPlayer) {
            this.cancelled = true;
            this.paused = false;
            this.notifyAll();
        }
    }

    public synchronized void reset() {
        this.timer.start("speakableOut");
    }

    public boolean drain() {
        this.timer.stop("speakableOut");
        return true;
    }

    public synchronized void close() {
        if (this.currentClip != null) {
            this.currentClip.stop();
            this.currentClip.close();
        }
        this.notifyAll();
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.volume = volume;
        if (this.currentClip != null) {
            this.setVolume(this.currentClip, volume);
        }
    }

    private void setPaused(boolean state) {
        this.paused = state;
    }

    private void setVolume(Clip clip, float vol) {
        if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volumeControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            float range = volumeControl.getMaximum() - volumeControl.getMinimum();
            volumeControl.setValue(vol * range + volumeControl.getMinimum());
        }
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public synchronized void begin(int size) {
        this.timer.start("utteranceOutput");
        this.cancelled = false;
        this.curIndex = 0;
        this.outputData = new byte[size];
    }

    public synchronized boolean end() {
        boolean ok = true;
        while (this.paused && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
        if (this.cancelled) {
            return false;
        }
        this.timer.start("clipGeneration");
        DataLine.Info info = new DataLine.Info(Clip.class, this.currentFormat);
        boolean opened = false;
        long totalDelayMs = 0L;
        do {
            try {
                this.currentClip = (Clip)AudioSystem.getLine(info);
                this.currentClip.addLineListener(this.lineListener);
                this.currentClip.open(this.currentFormat, this.outputData, 0, this.outputData.length);
                opened = true;
            }
            catch (LineUnavailableException lue) {
                System.err.println("LINE UNAVAILABLE: Format is " + this.currentFormat);
                try {
                    Thread.sleep(this.openFailDelayMs);
                    totalDelayMs += this.openFailDelayMs;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        } while (!opened && totalDelayMs < this.totalOpenFailDelayMs);
        if (!opened) {
            this.close();
            ok = false;
        } else {
            this.setVolume(this.currentClip, this.volume);
            this.currentClip.start();
            try {
                while (this.currentClip != null && (this.currentClip.isRunning() || this.paused) && !this.cancelled) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                ok = false;
            }
            this.close();
        }
        this.timer.stop("clipGeneration");
        this.timer.stop("utteranceOutput");
        return ok &= !this.cancelled;
    }

    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    public boolean write(byte[] bytes, int offset, int size) {
        if (this.firstSample) {
            this.firstSample = false;
            this.timer.stop("firstAudio");
        }
        System.arraycopy(bytes, offset, this.outputData, this.curIndex, size);
        this.curIndex += size;
        return true;
    }

    public String toString() {
        return "JavaClipAudioPlayer";
    }

    private void debugPrint(String msg) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + msg);
        }
    }

    public void showMetrics() {
        this.timer.show(this.toString());
    }

    public void startFirstSampleTimer() {
        this.timer.start("firstAudio");
        this.firstSample = true;
    }

    private class JavaClipLineListener
    implements LineListener {
        private JavaClipLineListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(LineEvent event) {
            if (event.getType().equals(LineEvent.Type.START)) {
                JavaClipAudioPlayer.this.debugPrint("Event  START");
            } else {
                if (event.getType().equals(LineEvent.Type.STOP)) {
                    JavaClipAudioPlayer.this.debugPrint("Event  STOP");
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        JavaClipAudioPlayer.this.notifyAll();
                    }
                }
                if (event.getType().equals(LineEvent.Type.OPEN)) {
                    JavaClipAudioPlayer.this.debugPrint("Event OPEN");
                } else if (event.getType().equals(LineEvent.Type.CLOSE)) {
                    JavaClipAudioPlayer.this.debugPrint("EVNT CLOSE");
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        JavaClipAudioPlayer.this.notifyAll();
                    }
                }
            }
        }
    }
}

