/*
 * Decompiled with CFR 0.152.
 */
package rcp_gtalk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rcp_gtalk.GtalkListener;

public class Gtalk {
    public static Log log;
    public static final String MALE1 = "male01";
    public static final String MALE2 = "male02";
    public static final String FEMALE1 = "female01";
    private String speaker = "male01";
    private GtalkListener listener;
    private boolean playing;
    public static final String DEFAULT_SETTING_NAME = "ssm.conf";
    private String gtalkBaseDir;
    private String gtalkSettringPath;
    private Process process;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("rcp_gtalk.Gtalk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz.getClass());
    }

    public String getGtalkBaseDir() {
        return this.gtalkBaseDir;
    }

    public void setGtalkBaseDir(String gtalkBaseDir) {
        this.gtalkBaseDir = gtalkBaseDir;
    }

    public String getGtalkSettringPath() {
        return this.gtalkSettringPath;
    }

    public void setGtalkSettringPath(String gtalkSettringPath) {
        this.gtalkSettringPath = gtalkSettringPath;
    }

    public GtalkListener getListener() {
        return this.listener;
    }

    public void setListener(GtalkListener listener) {
        this.listener = listener;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public String getSpeaker() {
        return this.speaker;
    }

    public void setSpeaker(String speaker) {
        this.speaker = speaker;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play(String text) throws IOException {
        block11: {
            if (this.playing) {
                log.debug((Object)"now playing");
                return;
            }
            this.playing = true;
            if (this.gtalkBaseDir == null) {
                log.warn((Object)"gtalkBaseDir not found");
                throw new IOException("gtalkBaseDir not found");
            }
            if (this.gtalkSettringPath == null) {
                log.warn((Object)"gtalkSettringPath not found");
                throw new IOException("gtalkSettringPath not found");
            }
            if (this.listener != null) {
                this.listener.playStart();
            } else {
                log.trace((Object)"listener is null");
            }
            Runtime runtime = Runtime.getRuntime();
            String values = "";
            values = String.valueOf(values) + "set Speaker=" + this.speaker + "\r\n";
            values = String.valueOf(values) + "set Text=" + text + "\r\n";
            values = String.valueOf(values) + "set Speak=NOW\r\n";
            try {
                try {
                    this.process = runtime.exec(new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath}, new String[0], new File(this.gtalkBaseDir));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                    String line = reader.readLine();
                    PrintWriter writer = new PrintWriter(this.process.getOutputStream());
                    writer.write(values);
                    writer.close();
                    while ((line = reader.readLine()) != null && this.process != null) {
                        log.trace((Object)line);
                        if (!line.equals("rep Speak.stat = IDLE")) continue;
                        this.process.destroy();
                        this.process = null;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.playing = false;
                throw throwable;
            }
            {
                Object var7_10 = null;
                this.playing = false;
                if (this.listener == null) break block11;
                this.listener.playEnd();
                return;
            }
        }
        log.trace((Object)"listener is null");
    }

    public void writeRaw(String text, File file) throws IOException {
        if (this.playing) {
            log.debug((Object)"now playing");
            return;
        }
        this.playing = true;
        if (this.listener != null) {
            this.listener.writeStart(file);
        } else {
            log.trace((Object)"listener is null");
        }
        Runtime runtime = Runtime.getRuntime();
        String values = "";
        values = String.valueOf(values) + "set Speaker=" + this.speaker + "\r\n";
        values = String.valueOf(values) + "set Text=" + text + "\r\n";
        values = String.valueOf(values) + "set Save=" + file.getAbsolutePath() + "\r\n";
        String other = MALE1;
        if (this.speaker.equals(MALE1)) {
            other = MALE2;
        }
        values = String.valueOf(values) + "set Speaker=" + other + "\r\n";
        String match = "rep Speaker = " + other;
        try {
            this.process = runtime.exec(new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath}, new String[0], new File(this.gtalkBaseDir));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = reader.readLine();
            PrintWriter writer = new PrintWriter(this.process.getOutputStream());
            log.info((Object)values);
            writer.write(values);
            writer.close();
            while ((line = reader.readLine()) != null) {
                log.info((Object)line);
                if (line.equals(match)) break;
            }
            this.process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.listener != null) {
            this.listener.writeEnd(file);
        } else {
            log.trace((Object)"listener is null");
        }
        this.playing = false;
    }

    public void writeWav(String text, File wavFile) throws IOException {
        if (this.playing) {
            log.debug((Object)"now playing");
            return;
        }
        this.playing = true;
        File file = File.createTempFile("gtalk", ".raw");
        if (this.listener != null) {
            this.listener.writeStart(wavFile);
        } else {
            log.trace((Object)"listener is null");
        }
        Runtime runtime = Runtime.getRuntime();
        String values = "";
        values = String.valueOf(values) + "set Speaker=" + this.speaker + "\r\n";
        values = String.valueOf(values) + "set Text=" + text + "\r\n";
        values = String.valueOf(values) + "set Save=" + file.getAbsolutePath() + "\r\n";
        String other = MALE1;
        if (this.speaker.equals(MALE1)) {
            other = MALE2;
        }
        values = String.valueOf(values) + "set Speaker=" + other + "\r\n";
        String match = "rep Speaker = " + other;
        try {
            this.process = runtime.exec(new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath}, new String[0], new File(this.gtalkBaseDir));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = reader.readLine();
            PrintWriter writer = new PrintWriter(this.process.getOutputStream());
            log.info((Object)values);
            writer.write(values);
            writer.close();
            while ((line = reader.readLine()) != null) {
                log.info((Object)line);
                if (line.equals(match)) break;
            }
            this.process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.listener != null) {
            this.listener.writeEnd(file);
        } else {
            log.trace((Object)"listener is null");
        }
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
        log.trace((Object)("file-length:" + file.length()));
        AudioInputStream inputStream = new AudioInputStream(new FileInputStream(file), format, file.length() / 2L);
        FileOutputStream output = new FileOutputStream(wavFile);
        long writtenBytes = AudioSystem.write(inputStream, AudioFileFormat.Type.WAVE, output);
        log.trace((Object)("writebyte:" + writtenBytes));
        inputStream.close();
        output.flush();
        output.close();
        boolean result = file.delete();
        log.trace((Object)("tmp delete:" + result));
        this.playing = false;
    }

    public void cancel() {
        if (this.process != null) {
            OutputStream output = this.process.getOutputStream();
            if (output != null) {
                PrintWriter writer = new PrintWriter(output);
                writer.write("set Speak = STOP\r\n");
                writer.close();
            } else {
                log.info((Object)"output is null");
            }
        } else {
            log.info((Object)"process is null");
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        } else {
            log.trace((Object)"process is null");
        }
        if (this.listener != null) {
            this.listener.canceled();
        } else {
            log.trace((Object)"listener is null");
        }
    }
}

