/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.BookmarkFolder;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookmarkUtil {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static void parse(String fileName, Vector bookmarks) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(fileName);
            Element root = doc.getDocumentElement();
            BookmarkUtil.processRoot(root, bookmarks);
        }
        catch (ParserConfigurationException e) {
            UpdateUI.logException(e);
        }
        catch (SAXException e) {
            UpdateUI.logException(e);
        }
        catch (IOException e) {
            UpdateUI.logException(e);
        }
    }

    public static SiteBookmark[] getBookmarks(Vector bookmarks) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < bookmarks.size()) {
            BookmarkUtil.processEntry(bookmarks.get(i), result);
            ++i;
        }
        return result.toArray(new SiteBookmark[result.size()]);
    }

    public static BookmarkFolder getFolder(Vector bookmarks, IPath path) {
        NamedModelObject object = BookmarkUtil.find(bookmarks, path);
        if (object != null && object instanceof BookmarkFolder) {
            return (BookmarkFolder)object;
        }
        return null;
    }

    public static NamedModelObject find(Vector bookmarks, IPath path) {
        Object[] array = bookmarks.toArray();
        return BookmarkUtil.find(array, path);
    }

    private static NamedModelObject find(Object[] array, IPath path) {
        String name = path.segment(0);
        int i = 0;
        while (i < array.length) {
            NamedModelObject obj = (NamedModelObject)array[i];
            if (obj.getName().equals(name)) {
                if (obj instanceof BookmarkFolder && path.segmentCount() > 1) {
                    IPath childPath = path.removeFirstSegments(1);
                    BookmarkFolder folder = (BookmarkFolder)obj;
                    return BookmarkUtil.find(folder.getChildren(null), childPath);
                }
                return obj;
            }
            ++i;
        }
        return null;
    }

    private static void processRoot(Node root, Vector bookmarks) {
        if (root.getNodeName().equals("bookmarks")) {
            NodeList children = root.getChildNodes();
            BookmarkUtil.processChildren(children, null, bookmarks);
        }
    }

    private static void processChildren(NodeList children, BookmarkFolder folder, Vector bookmarks) {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            NamedModelObject object = null;
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("site")) {
                    object = BookmarkUtil.createSite(child);
                } else if (child.getNodeName().equals("folder")) {
                    object = BookmarkUtil.createFolder(child);
                }
            }
            if (object != null) {
                if (folder != null) {
                    folder.addChild(object);
                } else {
                    bookmarks.add(object);
                }
                object.setModel(model);
            }
            ++i;
        }
    }

    private static SiteBookmark createSite(Node child) {
        String name = BookmarkUtil.getAttribute(child, "name");
        URL url = null;
        try {
            url = new URL(BookmarkUtil.getAttribute(child, "url"));
        }
        catch (MalformedURLException malformedURLException) {}
        String web = BookmarkUtil.getAttribute(child, "web");
        boolean webBookmark = web != null && web.equals("true");
        String sel = BookmarkUtil.getAttribute(child, "selected");
        boolean selected = sel != null && sel.equals("true");
        SiteBookmark bookmark = new SiteBookmark(name, url, webBookmark, selected);
        String local = BookmarkUtil.getAttribute(child, "local");
        bookmark.setLocal(local != null && local.equals("true"));
        String ign = BookmarkUtil.getAttribute(child, "ignored-categories");
        if (ign != null) {
            StringTokenizer stok = new StringTokenizer(ign, ",");
            ArrayList<String> array = new ArrayList<String>();
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                array.add(tok);
            }
            bookmark.setIgnoredCategories(array.toArray(new String[array.size()]));
        }
        return bookmark;
    }

    private static BookmarkFolder createFolder(Node child) {
        BookmarkFolder folder = new BookmarkFolder();
        String name = BookmarkUtil.getAttribute(child, "name");
        folder.setName(name);
        if (child.hasChildNodes()) {
            NodeList children = child.getChildNodes();
            BookmarkUtil.processChildren(children, folder, null);
        }
        return folder;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(String fileName, Vector bookmarks) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                writer = new PrintWriter(osw);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<bookmarks>");
                int i = 0;
                while (true) {
                    if (i >= bookmarks.size()) {
                        writer.println("</bookmarks>");
                        writer.flush();
                        writer.close();
                    }
                    Object obj = bookmarks.get(i);
                    BookmarkUtil.writeObject("   ", obj, writer);
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (osw != null) {
            osw.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fos == null) return;
        fos.close();
    }

    private static void writeObject(String indent, Object obj, PrintWriter writer) {
        if (obj instanceof SiteBookmark) {
            SiteBookmark bookmark = (SiteBookmark)obj;
            String name = bookmark.getName();
            String url = bookmark.getURL().toString();
            String web = bookmark.isWebBookmark() ? "true" : "false";
            String sel = bookmark.isSelected() ? "true" : "false";
            String local = bookmark.isLocal() ? "true" : "false";
            String[] ign = bookmark.getIgnoredCategories();
            StringBuffer wign = new StringBuffer();
            int i = 0;
            while (i < ign.length) {
                if (i > 0) {
                    wign.append(',');
                }
                wign.append(ign[i]);
                ++i;
            }
            writer.print(String.valueOf(indent) + "<site name=\"" + name + "\" url=\"" + url + "\" web=\"" + web + "\" selected=\"" + sel + "\" local=\"" + local + "\"");
            if (wign.length() > 0) {
                writer.print(" ignored-categories=\"" + wign.toString() + "\"");
            }
            writer.println("/>");
        } else if (obj instanceof BookmarkFolder) {
            BookmarkFolder folder = (BookmarkFolder)obj;
            String name = folder.getName();
            writer.println(String.valueOf(indent) + "<folder name=\"" + name + "\">");
            Object[] children = folder.getChildren(folder);
            String indent2 = String.valueOf(indent) + "   ";
            int i = 0;
            while (i < children.length) {
                BookmarkUtil.writeObject(indent2, children[i], writer);
                ++i;
            }
            writer.println(String.valueOf(indent) + "</folder>");
        }
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem(name);
        if (att != null) {
            return att.getNodeValue();
        }
        return "";
    }

    private static void processFolder(BookmarkFolder folder, ArrayList result) {
        Object[] children = folder.getChildren(folder);
        int i = 0;
        while (i < children.length) {
            BookmarkUtil.processEntry(children[i], result);
            ++i;
        }
    }

    private static void processEntry(Object obj, ArrayList result) {
        if (obj instanceof SiteBookmark) {
            result.add(obj);
        } else if (obj instanceof BookmarkFolder) {
            BookmarkUtil.processFolder((BookmarkFolder)obj, result);
        }
    }
}

