/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.FileAudioPlayer;
import org.jpn.xucker.commons.audio.InputStreamAudioPlayer;

public class JavaSoundAudioPlayer
implements FileAudioPlayer,
InputStreamAudioPlayer {
    public static Log log;
    protected AudioStopper stopper;
    protected int buffer = 1024;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.JavaSoundAudioPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public AudioStopper getStopper() {
        return this.stopper;
    }

    public void setStopper(AudioStopper stopper) {
        this.stopper = stopper;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public void play(File file) {
        try {
            log.trace((Object)("play-file:" + file.getAbsolutePath()));
            log.trace((Object)("file-lehgth:" + file.length()));
            this.play(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void play(InputStream stream) {
        try {
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
            AudioFormat format = inputStream.getFormat();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            int readBytes = 0;
            byte[] bytedata = new byte[1024];
            while (readBytes != -1) {
                if (this.stopper != null && this.stopper.isStopped()) break;
                readBytes = inputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                line.write(bytedata, 0, readBytes);
            }
            line.drain();
            line.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long countByteAt(AudioFormat format, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        long rateIndex = (int)(format.getFrameRate() / 1000.0f * (float)millisecond);
        return rateIndex * (long)format.getSampleSizeInBits() / 8L * (long)format.getChannels();
    }

    public void play(File file, long startmillisecond, long endmillisecond) {
        try {
            this.play(new FileInputStream(file), startmillisecond, endmillisecond);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void play(InputStream stream, long startmillisecond, long endmillisecond) {
        try {
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(stream);
            AudioFormat format = audioInputStream.getFormat();
            long startByte = JavaSoundAudioPlayer.countByteAt(format, startmillisecond);
            long endByte = JavaSoundAudioPlayer.countByteAt(format, endmillisecond);
            long playByte = endByte - startByte;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            audioInputStream.skip(startByte);
            int readBytes = 0;
            int buffersize = 256;
            byte[] bytedata = new byte[buffersize];
            long readedByte = 0L;
            while (readBytes != -1) {
                if (this.stopper != null && this.stopper.isStopped()) break;
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                if (readedByte + (long)readBytes >= playByte) {
                    line.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                    break;
                }
                line.write(bytedata, 0, readBytes);
                readedByte += (long)readBytes;
            }
            byte[] tmpbyte = new byte[32768];
            line.write(tmpbyte, 0, tmpbyte.length);
            line.drain();
            line.stop();
            line.close();
            line = null;
            audioInputStream.close();
            audioInputStream = null;
            info = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

