/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.ipod;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.ipod.DoubleLineTextPopper;
import org.jpn.xucker.commons.ipod.MenuMaker;
import org.jpn.xucker.commons.ipod.PrevNextMenu;
import org.jpn.xucker.commons.ipod.TextPopper;
import org.jpn.xucker.commons.ipod.TextUtil;

public class TextConverter {
    public String encode = "Shift_JIS";
    public String audioPath;
    public int margin = 64;
    public String title;
    public String header;
    public String footer;
    public MenuMaker menuMaker = new PrevNextMenu();
    public String audioName = "PLAY";
    public TextPopper popper = new DoubleLineTextPopper();
    public static Log log;
    public String lineSeparator = "\r\n";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.ipod.TextConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String[] convert(String baseName, String text) {
        String[] baseText = this.split(baseName, text);
        log.debug((Object)"split");
        int i = 0;
        while (i < baseText.length) {
            int number = i + 1;
            StringBuffer mainBuffer = new StringBuffer();
            mainBuffer.append(TextUtil.toEncode(this.encode));
            mainBuffer.append(this.lineSeparator);
            mainBuffer.append(TextUtil.toTitle(String.valueOf(baseName) + " " + number));
            mainBuffer.append(this.lineSeparator);
            if (i == 0 && this.audioPath != null) {
                mainBuffer.append(TextUtil.toLink(this.audioName, this.audioPath));
                mainBuffer.append(this.lineSeparator);
            }
            mainBuffer.append(baseText[i]);
            mainBuffer.append(this.lineSeparator);
            mainBuffer.append(this.menuMaker.getMenu(i, baseText.length));
            if (log.isDebugEnabled()) {
                int textSize = TextUtil.countText(baseText[i], this.encode);
                int allSize = TextUtil.countText(mainBuffer.toString(), this.encode);
                log.debug((Object)("text size:" + allSize + "," + textSize + "," + (allSize - textSize)));
            }
            baseText[i] = TextUtil.toFix(mainBuffer.toString());
            ++i;
        }
        return baseText;
    }

    public String[] split(String baseName, String text) {
        Vector<String> stringVector = new Vector<String>();
        int ignorebyte = this.margin;
        this.menuMaker.setBaseName(baseName);
        this.menuMaker.setText(text);
        ignorebyte += this.menuMaker.getBytes(this.encode);
        ignorebyte += this.countOtherByte();
        log.debug((Object)("header size" + (ignorebyte += TextUtil.toEncode(this.encode).length())));
        StringBuffer textData = new StringBuffer();
        String tmpLine = null;
        int count = 0;
        this.popper.setText(text);
        boolean countAudio = false;
        while ((tmpLine = this.popper.nextLine()) != null) {
            if (!countAudio && this.audioPath != null) {
                count += TextUtil.countText(TextUtil.toLink(this.audioName, this.audioPath), this.encode);
                countAudio = false;
            }
            if ((count += TextUtil.countText(String.valueOf(tmpLine) + this.lineSeparator, this.encode)) + ignorebyte > 4096) {
                log.debug((Object)("over " + count + "," + ignorebyte));
                stringVector.add(textData.toString());
                log.debug((Object)("text size:" + TextUtil.countText(textData.toString(), this.encode)));
                textData = new StringBuffer();
                textData.append(String.valueOf(tmpLine) + this.lineSeparator);
                count = TextUtil.countText(String.valueOf(tmpLine) + this.lineSeparator, this.encode);
                continue;
            }
            textData.append(String.valueOf(tmpLine) + this.lineSeparator);
        }
        if (textData.length() > 0) {
            stringVector.add(textData.toString());
        }
        log.debug((Object)("text size " + stringVector.size()));
        return stringVector.toArray(new String[stringVector.size()]);
    }

    public int countOtherByte() {
        int all = TextUtil.countText(TextUtil.toTitle(this.title), this.encode);
        if (this.header != null) {
            all += TextUtil.countText(this.header, this.encode);
        }
        if (this.footer != null) {
            all += TextUtil.countText(this.footer, this.encode);
        }
        return all;
    }
}

